/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.me.p2p;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.core.AEConfig;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.heat.TemperatureListener;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class HeatP2PTunnelPart
extends P2PTunnelPart<HeatP2PTunnelPart> {
    private static final P2PModels MODELS = new P2PModels(ResourceLocation.tryBuild((String)"appliedpneumatics", (String)"part/p2p/p2p_tunnel_heat"));
    private static final BlockCapability<IHeatExchangerLogic, Direction> HEAT_CAP = PNCCapabilities.HEAT_EXCHANGER_BLOCK;
    @Nullable
    private IHeatExchangerLogic inputAdjacentCache;
    private int reentryDepth = 0;
    private final IHeatExchangerLogic inputHandler = new InputHeatAdapter();
    private final IHeatExchangerLogic outputHandler = new OutputHeatAdapter();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public HeatP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem);
    }

    public IHeatExchangerLogic getExposedApi() {
        return this.isOutput() ? this.outputHandler : this.inputHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private IHeatExchangerLogic resolveInputAdjacentOrNull() {
        if (this.reentryDepth++ > 0) {
            --this.reentryDepth;
            return null;
        }
        try {
            BlockEntity be = this.getBlockEntity();
            Direction face = this.getSide();
            if (be == null || face == null) {
                IHeatExchangerLogic iHeatExchangerLogic = null;
                return iHeatExchangerLogic;
            }
            Level level = be.getLevel();
            if (level == null) {
                IHeatExchangerLogic iHeatExchangerLogic = null;
                return iHeatExchangerLogic;
            }
            if (level instanceof ServerLevel) {
                IHeatExchangerLogic relativedPos;
                ServerLevel sl = (ServerLevel)level;
                if (this.inputAdjacentCache == null) {
                    relativedPos = be.getBlockPos().relative(face);
                    Direction capSide = face.getOpposite();
                    this.inputAdjacentCache = HeatExchangerManager.getInstance().getLogic((Level)sl, (BlockPos)relativedPos, capSide).orElse(null);
                }
                relativedPos = this.inputAdjacentCache;
                return relativedPos;
            }
            BlockPos relativedPos = be.getBlockPos().relative(face);
            Direction capSide = face.getOpposite();
            IHeatExchangerLogic iHeatExchangerLogic = HeatExchangerManager.getInstance().getLogic(level, relativedPos, capSide).orElse(null);
            return iHeatExchangerLogic;
        }
        finally {
            --this.reentryDepth;
        }
    }

    @Nullable
    private static IHeatExchangerLogic resolveOutputAdjacentOrNull(HeatP2PTunnelPart out) {
        BlockEntity be = out.getBlockEntity();
        Direction face = out.getSide();
        if (be == null || face == null) {
            return null;
        }
        Level level = be.getLevel();
        if (level == null) {
            return null;
        }
        BlockPos relativedPos = be.getBlockPos().relative(face);
        Direction capSide = face.getOpposite();
        return HeatExchangerManager.getInstance().getLogic(level, relativedPos, capSide).orElse(null);
    }

    private void resetInputAdjacentCacheAndInvalidate() {
        this.inputAdjacentCache = null;
        BlockEntity be = this.getBlockEntity();
        if (be != null) {
            be.invalidateCapabilities();
        }
        if (!this.isOutput()) {
            for (HeatP2PTunnelPart out : this.getOutputs()) {
                BlockEntity obe = out.getBlockEntity();
                if (obe == null) continue;
                obe.invalidateCapabilities();
            }
        } else {
            BlockEntity ibe;
            HeatP2PTunnelPart in = (HeatP2PTunnelPart)this.getInput();
            if (in != null && (ibe = in.getBlockEntity()) != null) {
                ibe.invalidateCapabilities();
            }
        }
    }

    public void onTunnelNetworkChange() {
        this.resetInputAdjacentCacheAndInvalidate();
    }

    public void onTunnelConfigChange() {
        this.resetInputAdjacentCacheAndInvalidate();
    }

    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        this.resetInputAdjacentCacheAndInvalidate();
    }

    public void onUpdateShape(Direction side) {
        if (side == this.getSide()) {
            this.resetInputAdjacentCacheAndInvalidate();
        }
    }

    private class InputHeatAdapter
    implements IHeatExchangerLogic {
        private static final double ABSOLUTE_ZERO_K = 0.0;
        private static final double MAX_BLOCK_TEMP_K = 2273.0;
        private double ambientTemperature = 300.0;
        private boolean ambientInited = false;

        private InputHeatAdapter() {
        }

        private double resolveAmbientTemperature() {
            BlockEntity be;
            if (!this.ambientInited && (be = HeatP2PTunnelPart.this.getBlockEntity()) != null && be.getLevel() != null) {
                this.ambientTemperature = HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)be.getLevel(), (BlockPos)be.getBlockPos());
                this.ambientInited = true;
            }
            return this.ambientTemperature;
        }

        public void addHeat(double heatJ) {
            double operations;
            double tax;
            if (heatJ == 0.0) {
                return;
            }
            BlockEntity selfBe = HeatP2PTunnelPart.this.getBlockEntity();
            if (selfBe == null) {
                return;
            }
            Level level = selfBe.getLevel();
            if (level == null || level.isClientSide) {
                return;
            }
            IHeatExchangerLogic source = HeatP2PTunnelPart.this.resolveInputAdjacentOrNull();
            if (source == null) {
                return;
            }
            double sourceTempK = source.getTemperature();
            List<HeatP2PTunnelPart> outputs = List.copyOf(HeatP2PTunnelPart.this.getOutputs());
            if (outputs.isEmpty()) {
                return;
            }
            double flowSign = Math.signum(heatJ);
            record Sink(IHeatExchangerLogic exchanger, double allocatableEnergyJ) {
            }
            ArrayList<Sink> sinks = new ArrayList<Sink>(outputs.size());
            double totalAllocatableJ = 0.0;
            for (HeatP2PTunnelPart out : outputs) {
                double headroomJ;
                double allocatableJ;
                double capacity;
                IHeatExchangerLogic neighbor = HeatP2PTunnelPart.resolveOutputAdjacentOrNull(out);
                if (neighbor == null || (capacity = Math.max(0.0, neighbor.getThermalCapacity())) <= 0.0) continue;
                double targetTempK = neighbor.getTemperature();
                double demandToSourceJ = flowSign > 0.0 ? Math.max(0.0, sourceTempK - targetTempK) * capacity : Math.max(0.0, targetTempK - sourceTempK) * capacity;
                if (demandToSourceJ <= 0.0 || (allocatableJ = Math.min(demandToSourceJ, headroomJ = flowSign > 0.0 ? Math.max(0.0, (2273.0 - targetTempK) * capacity) : Math.max(0.0, (targetTempK - 0.0) * capacity))) <= 0.0) continue;
                sinks.add(new Sink(neighbor, allocatableJ));
                totalAllocatableJ += allocatableJ;
            }
            if (totalAllocatableJ <= 0.0) {
                return;
            }
            double fraction = Math.min(1.0, Math.abs(heatJ) / totalAllocatableJ);
            for (Sink s : sinks) {
                double assignedJ = flowSign * fraction * s.allocatableEnergyJ();
                if (assignedJ == 0.0) continue;
                s.exchanger().addHeat(assignedJ);
            }
            double deliveredAbsJ = fraction * totalAllocatableJ;
            double costPerOp = AEConfig.instance().getP2PTunnelTransportTax();
            if (costPerOp > 0.0 && deliveredAbsJ > 0.0 && (tax = (operations = deliveredAbsJ / 1000.0) * costPerOp) > 0.0) {
                HeatP2PTunnelPart.this.getMainNode().ifPresent(grid -> grid.getEnergyService().extractAEPower(tax, Actionable.MODULATE, PowerMultiplier.CONFIG));
            }
        }

        public double getTemperature() {
            List<HeatP2PTunnelPart> outs = List.copyOf(HeatP2PTunnelPart.this.getOutputs());
            double sumW = 0.0;
            double sumTW = 0.0;
            for (HeatP2PTunnelPart out : outs) {
                double c;
                IHeatExchangerLogic h = HeatP2PTunnelPart.resolveOutputAdjacentOrNull(out);
                if (h == null || (c = Math.max(0.0, h.getThermalCapacity())) <= 0.0) continue;
                sumW += c;
                sumTW += h.getTemperature() * c;
            }
            if (sumW > 0.0) {
                return sumTW / sumW;
            }
            double sumT = 0.0;
            int n = 0;
            for (HeatP2PTunnelPart out : outs) {
                IHeatExchangerLogic h = HeatP2PTunnelPart.resolveOutputAdjacentOrNull(out);
                if (h == null) continue;
                sumT += h.getTemperature();
                ++n;
            }
            return n > 0 ? sumT / (double)n : this.getAmbientTemperature();
        }

        public int getTemperatureAsInt() {
            return (int)Math.round(this.getTemperature());
        }

        public double getAmbientTemperature() {
            List<HeatP2PTunnelPart> outs = List.copyOf(HeatP2PTunnelPart.this.getOutputs());
            double sum = 0.0;
            int n = 0;
            for (HeatP2PTunnelPart out : outs) {
                IHeatExchangerLogic h = HeatP2PTunnelPart.resolveOutputAdjacentOrNull(out);
                if (h == null) continue;
                sum += h.getAmbientTemperature();
                ++n;
            }
            return n == 0 ? this.resolveAmbientTemperature() : sum / (double)n;
        }

        public double getThermalResistance() {
            List<HeatP2PTunnelPart> outs = List.copyOf(HeatP2PTunnelPart.this.getOutputs());
            double sum = 0.0;
            int n = 0;
            for (HeatP2PTunnelPart out : outs) {
                IHeatExchangerLogic h = HeatP2PTunnelPart.resolveOutputAdjacentOrNull(out);
                if (h == null) continue;
                sum += h.getThermalResistance();
                ++n;
            }
            return n == 0 ? (Double)ConfigHelper.common().heat.airThermalResistance.get() : sum / (double)n;
        }

        public double getThermalCapacity() {
            List<HeatP2PTunnelPart> outs = List.copyOf(HeatP2PTunnelPart.this.getOutputs());
            double total = 0.0;
            for (HeatP2PTunnelPart out : outs) {
                IHeatExchangerLogic h = HeatP2PTunnelPart.resolveOutputAdjacentOrNull(out);
                if (h == null) continue;
                total += Math.max(0.0, h.getThermalCapacity());
            }
            return Math.max(0.0, total);
        }

        public void setTemperature(double temperature) {
        }

        public void setThermalResistance(double r) {
        }

        public void setThermalCapacity(double c) {
        }

        public void tick() {
        }

        public void initializeAsHull(Level level, BlockPos pos, BiPredicate<LevelAccessor, BlockPos> f, Direction ... sides) {
        }

        public void initializeAmbientTemperature(Level level, BlockPos pos) {
        }

        public boolean isSideConnected(Direction side) {
            return side == HeatP2PTunnelPart.this.getSide();
        }

        public void addTemperatureListener(TemperatureListener l) {
        }

        public void removeTemperatureListener(TemperatureListener l) {
        }

        public CompoundTag serializeNBT() {
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
        }

        public <T extends HeatBehaviour> Optional<T> getHeatBehaviour(BlockPos pos, Class<T> cls) {
            return Optional.empty();
        }
    }

    private class OutputHeatAdapter
    implements IHeatExchangerLogic {
        private double ambientTemperature = 300.0;
        private boolean ambientInited = false;

        private OutputHeatAdapter() {
        }

        private double resolveAmbientTemperature() {
            BlockEntity be;
            if (!this.ambientInited && (be = HeatP2PTunnelPart.this.getBlockEntity()) != null && be.getLevel() != null) {
                this.ambientTemperature = HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)be.getLevel(), (BlockPos)be.getBlockPos());
                this.ambientInited = true;
            }
            return this.ambientTemperature;
        }

        public double getThermalCapacity() {
            return 0.0;
        }

        public void addHeat(double amount) {
        }

        public double getTemperature() {
            return this.getAmbientTemperature();
        }

        public int getTemperatureAsInt() {
            return (int)Math.round(this.getTemperature());
        }

        public double getAmbientTemperature() {
            return this.resolveAmbientTemperature();
        }

        public void setTemperature(double temperature) {
        }

        public void setThermalResistance(double r) {
        }

        public double getThermalResistance() {
            return (Double)ConfigHelper.common().heat.airThermalResistance.get();
        }

        public void setThermalCapacity(double c) {
        }

        public void tick() {
        }

        public void initializeAsHull(Level level, BlockPos pos, BiPredicate<LevelAccessor, BlockPos> f, Direction ... sides) {
        }

        public void initializeAmbientTemperature(Level level, BlockPos pos) {
        }

        public boolean isSideConnected(Direction side) {
            return side == HeatP2PTunnelPart.this.getSide();
        }

        public void addTemperatureListener(TemperatureListener l) {
        }

        public void removeTemperatureListener(TemperatureListener l) {
        }

        public CompoundTag serializeNBT() {
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
        }

        public <T extends HeatBehaviour> Optional<T> getHeatBehaviour(BlockPos pos, Class<T> cls) {
            return Optional.empty();
        }
    }
}

