/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.me.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsTooltip;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.wintercogs.appliedpneumatics.common.init.APDataComponents;
import com.wintercogs.appliedpneumatics.common.me.crafting.EncodedAmadronPattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class AmadronPatternDetails
implements IPatternDetails {
    private final AEItemKey definition;
    private final Input[] inputs;
    private final List<GenericStack> outputs;
    private final ResourceLocation offerId;

    public AmadronPatternDetails(AEItemKey definition) {
        this.definition = definition;
        EncodedAmadronPattern pattern = (EncodedAmadronPattern)definition.get((DataComponentType)APDataComponents.AMADRON_PATTERN.get());
        if (pattern == null) {
            throw new IllegalArgumentException("Given item does not encode a processing pattern: " + String.valueOf(definition));
        }
        AmadronOffer offer = AmadronOfferManager.getInstance().getOffer(pattern.offerId());
        if (offer == null) {
            throw new IllegalArgumentException("Given item does not have an offer: " + String.valueOf(definition));
        }
        this.offerId = offer.getOfferId();
        ItemStack mayInputStackItem = offer.getInput().getItem();
        FluidStack mayInputStackFluid = offer.getInput().getFluid();
        GenericStack input = mayInputStackItem.isEmpty() ? GenericStack.fromFluidStack((FluidStack)mayInputStackFluid) : GenericStack.fromItemStack((ItemStack)mayInputStackItem);
        this.inputs = new Input[]{new Input(input)};
        ItemStack mayOutputStackItem = offer.getOutput().getItem();
        FluidStack mayOutputStackFluid = offer.getOutput().getFluid();
        GenericStack output = mayOutputStackItem.isEmpty() ? GenericStack.fromFluidStack((FluidStack)mayOutputStackFluid) : GenericStack.fromItemStack((ItemStack)mayOutputStackItem);
        this.outputs = new ArrayList<GenericStack>(Collections.singleton(output));
    }

    public ResourceLocation getOfferId() {
        return this.offerId;
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    public List<GenericStack> getOutputs() {
        return this.outputs;
    }

    public static void encode(ItemStack stack, ResourceLocation offerId) {
        if (AmadronOfferManager.getInstance().getOffer(offerId) != null) {
            stack.set(APDataComponents.AMADRON_PATTERN, (Object)new EncodedAmadronPattern(offerId));
        }
    }

    public static PatternDetailsTooltip getInvalidPatternTooltip(ItemStack stack, Level level, @Nullable Exception cause, TooltipFlag flags) {
        PatternDetailsTooltip tooltip = new PatternDetailsTooltip(PatternDetailsTooltip.OUTPUT_TEXT_PRODUCES);
        EncodedAmadronPattern encodedPattern = (EncodedAmadronPattern)stack.get(APDataComponents.AMADRON_PATTERN);
        if (encodedPattern != null && AmadronOfferManager.getInstance().getOffer(encodedPattern.offerId()) != null) {
            AmadronPatternDetails.addTooltipFromAmadronResource(tooltip, AmadronOfferManager.getInstance().getOffer(encodedPattern.offerId()).getInput(), true);
            AmadronPatternDetails.addTooltipFromAmadronResource(tooltip, AmadronOfferManager.getInstance().getOffer(encodedPattern.offerId()).getOutput(), false);
        }
        return tooltip;
    }

    private static void addTooltipFromAmadronResource(PatternDetailsTooltip tooltip, AmadronTradeResource resource, boolean toInput) {
        if (!resource.getItem().isEmpty()) {
            if (toInput) {
                tooltip.addInput((AEKey)AEItemKey.of((ItemStack)resource.getItem()), (long)resource.getAmount());
            } else {
                tooltip.addOutput((AEKey)AEItemKey.of((ItemStack)resource.getItem()), (long)resource.getAmount());
            }
        } else if (!resource.getFluid().isEmpty()) {
            if (toInput) {
                tooltip.addInput((AEKey)AEFluidKey.of((FluidStack)resource.getFluid()), (long)resource.getAmount());
            } else {
                tooltip.addOutput((AEKey)AEFluidKey.of((FluidStack)resource.getFluid()), (long)resource.getAmount());
            }
        }
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AmadronPatternDetails) {
            AmadronPatternDetails patternDetails = (AmadronPatternDetails)obj;
            return this.definition.equals((Object)patternDetails.definition);
        }
        return false;
    }

    private static class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] template;
        private final long multiplier;

        private Input(GenericStack stack) {
            this.template = new GenericStack[]{new GenericStack(stack.what(), 1L)};
            this.multiplier = stack.amount();
        }

        public GenericStack[] getPossibleInputs() {
            return this.template;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.template[0]);
        }

        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

