/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.client.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.appliedpneumatics.util.IngredientRenderer;
import java.util.ArrayList;
import java.util.Optional;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmadronOfferPanel
extends AbstractWidget {
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"appliedpneumatics", (String)"textures/gui/amadron_wireless_terminal.png");
    private static final Bounds staticOfferUVBounds = new Bounds(95, 282, 8, 11);
    private static final Bounds villagerOfferUVBounds = new Bounds(83, 282, 8, 11);
    private static final Bounds playerOfferUVBounds = new Bounds(107, 283, 8, 8);
    private static final int PANEL_W = 79;
    private static final int PANEL_H = 22;
    private static final int ICON_W = 16;
    private static final int ICON_H = 16;
    private static final int IN_ICON_X = 3;
    private static final int ICON_Y = 3;
    private static final int OUT_ICON_X = 60;
    private static final int OUT_ICON_Y = 3;
    private static final float TEXT_SCALE = 0.666f;
    private static final float TEXT_Z = 300.0f;
    private final ResourceLocation offerId;
    private final Component supplierName;
    private final OfferType offerType;
    private final AmadronTradeResource input;
    private final AmadronTradeResource output;
    private final int maxStock;
    private int wantedStock;
    @Nullable
    private final onPress onClicked;
    private final boolean valid;

    private static boolean inBox(int mx, int my, int x, int y, int w, int h) {
        return mx >= x && mx < x + w && my >= y && my < y + h;
    }

    private AmadronOfferPanel(int x, int y, ResourceLocation offerId, @Nullable AmadronOffer offer, @Nullable onPress onClicked) {
        super(x, y, 79, 22, (Component)Component.translatable((String)"appliedpneumatics.gui.widget.amadron_offer_panel"));
        this.offerId = offerId;
        this.onClicked = onClicked;
        if (offer != null) {
            this.valid = true;
            this.offerType = new OfferType(offer.isStaticOffer(), offer.isVillagerTrade(), offer instanceof AmadronPlayerOffer);
            this.input = offer.getInput();
            this.output = offer.getOutput();
            this.maxStock = offer.getStock();
            this.supplierName = offer.getVendorName();
        } else {
            this.valid = false;
            this.offerType = new OfferType(false, false, false);
            this.input = AmadronTradeResource.of((ItemStack)ItemStack.EMPTY);
            this.output = AmadronTradeResource.of((ItemStack)ItemStack.EMPTY);
            this.maxStock = -1;
            this.supplierName = Component.empty();
        }
    }

    public static AmadronOfferPanel fromOfferId(int x, int y, ResourceLocation id, onPress runnable) {
        AmadronOffer offer = AmadronOfferManager.getInstance().getOffer(id);
        return new AmadronOfferPanel(x, y, id, offer, runnable);
    }

    public int getWantedStock() {
        return this.wantedStock;
    }

    public ResourceLocation getOfferId() {
        return this.offerId;
    }

    public boolean isValidOffer() {
        return this.valid;
    }

    public OfferType getOfferType() {
        return this.offerType;
    }

    public AmadronTradeResource getInput() {
        return this.input;
    }

    public AmadronTradeResource getOutput() {
        return this.output;
    }

    public void onClicked(double mouseX, double mouseY, int button, boolean isShiftKeyDown) {
        super.onClick(mouseX, mouseY, button);
        if (button == 0 || button == 1) {
            if (isShiftKeyDown) {
                double wantmulit = button == 0 ? 0.5 : 2.0;
                this.wantedStock = (int)Math.max(0.0, (double)this.wantedStock * wantmulit);
                if (this.maxStock > -1) {
                    this.wantedStock = Math.min(this.maxStock, this.wantedStock);
                }
                this.wantedStock = Math.min(256, this.wantedStock);
            } else {
                int wantedAdd = button == 0 ? -1 : 1;
                this.wantedStock = Math.max(0, this.wantedStock + wantedAdd);
                if (this.maxStock > -1) {
                    this.wantedStock = Math.min(this.maxStock, this.wantedStock);
                }
                this.wantedStock = Math.min(64, this.wantedStock);
            }
        } else if (button == 2) {
            this.wantedStock = 0;
        }
    }

    protected void renderWidget(@NotNull GuiGraphics gui, int mouseX, int mouseY, float pt) {
        if (this.isMouseOver(mouseX, mouseY)) {
            gui.blit(BG, this.getX(), this.getY(), 1.0f, 294.0f, 79, 22, 512, 512);
        } else {
            gui.blit(BG, this.getX(), this.getY(), 1.0f, 271.0f, 79, 22, 512, 512);
        }
        if (!this.valid) {
            gui.drawString(Minecraft.getInstance().font, "\u2026", this.getX() + 4, this.getY() + 7, 0x777777);
            return;
        }
        Font font = Minecraft.getInstance().font;
        int x0 = this.getX();
        int y0 = this.getY();
        AmadronOfferPanel.drawAmadronTradeResource(gui, this.input, font, x0 + 3, y0 + 3);
        AmadronOfferPanel.drawAmadronTradeResource(gui, this.output, font, x0 + 60, y0 + 3);
        int typeU = -1;
        int typeV = -1;
        int typeW = -1;
        int typeH = -1;
        if (this.offerType.isStatic && !this.offerType.isPlayer) {
            typeU = AmadronOfferPanel.staticOfferUVBounds.x;
            typeV = AmadronOfferPanel.staticOfferUVBounds.y;
            typeW = AmadronOfferPanel.staticOfferUVBounds.width;
            typeH = AmadronOfferPanel.staticOfferUVBounds.height;
        } else if (this.offerType.isVillager) {
            typeU = AmadronOfferPanel.villagerOfferUVBounds.x;
            typeV = AmadronOfferPanel.villagerOfferUVBounds.y;
            typeW = AmadronOfferPanel.villagerOfferUVBounds.width;
            typeH = AmadronOfferPanel.villagerOfferUVBounds.height;
        } else if (this.offerType.isPlayer) {
            typeU = AmadronOfferPanel.playerOfferUVBounds.x;
            typeV = AmadronOfferPanel.playerOfferUVBounds.y;
            typeW = AmadronOfferPanel.playerOfferUVBounds.width;
            typeH = AmadronOfferPanel.playerOfferUVBounds.height;
        }
        if (typeU != -1 && typeV != -1 && typeW != -1 && typeH != -1 && !this.offerType.isPlayer) {
            gui.blit(BG, this.getX() + 35, this.getY() + 9, 300, (float)typeU, (float)typeV, typeW, typeH, 512, 512);
        } else if (typeU != -1 && typeV != -1 && typeW != -1 && typeH != -1) {
            gui.blit(BG, this.getX() + 35, this.getY() + 10, 300, (float)typeU, (float)typeV, typeW, typeH, 512, 512);
        }
        PoseStack pose = gui.pose();
        pose.pushPose();
        pose.translate((float)x0, (float)y0, 300.0f);
        pose.scale(0.5f, 0.5f, 1.0f);
        String wantedText = "";
        String maxStockText = "";
        if (this.wantedStock > 0) {
            wantedText = String.valueOf(this.wantedStock);
        }
        if (this.maxStock > -1) {
            maxStockText = String.valueOf(this.maxStock);
        }
        String renderText = !maxStockText.isEmpty() ? String.valueOf(this.wantedStock) + " / " + maxStockText : wantedText;
        gui.drawCenteredString(font, renderText, 77, 5, 0xFFFFFF);
        pose.popPose();
    }

    private static void drawAmadronTradeResource(GuiGraphics gui, AmadronTradeResource resource, Font font, int x, int y) {
        ItemStack mayItem = resource.getItem();
        FluidStack mayFluid = resource.getFluid();
        if (!mayItem.isEmpty()) {
            gui.renderItem(mayItem, x, y);
            AmadronOfferPanel.drawCountBottomRight(gui, font, String.valueOf(mayItem.getCount()), x, y);
        } else if (!mayFluid.isEmpty()) {
            IngredientRenderer.darwFluidAs16WHTiledSprite(gui, mayFluid.getFluid(), x, y);
            String inText = String.format("%.1fB", (double)mayFluid.getAmount() / 1000.0);
            AmadronOfferPanel.drawCountBottomRight(gui, font, inText, x, y);
        }
    }

    private static void drawCountBottomRight(GuiGraphics g, Font font, String text, int iconX, int iconY) {
        float s = 0.666f;
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 300.0f);
        pose.scale(s, s, s);
        int w = font.width(text);
        int X = (int)(((float)(iconX + -1) + 16.0f + 2.0f - (float)w * s) / s);
        int Y = (int)(((float)(iconY + -1) + 16.0f - 5.0f * s) / s);
        g.drawString(font, text, X, Y, 0xFFFFFF);
        pose.popPose();
    }

    public void renderStackTooltip(GuiGraphics gui, int mouseX, int mouseY, int offsetX, int offsetY) {
        if (!this.valid || !this.isMouseOverForTooltip(mouseX, mouseY)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        ArrayList<Object> tooltips = new ArrayList<Object>();
        TriFunction<String, ChatFormatting, Component, Component> twoColorC = (leftKey, leftColor, rightComp) -> Component.empty().append((Component)Component.translatable((String)leftKey).withStyle(leftColor)).append((Component)rightComp.copy().withStyle(ChatFormatting.WHITE));
        tooltips.add(twoColorC.apply("tooltip.appliedpneumatics.amadron_trade.supplier", ChatFormatting.YELLOW, this.supplierName));
        tooltips.add(twoColorC.apply("tooltip.appliedpneumatics.amadron_trade.output", ChatFormatting.YELLOW, (Component)Component.literal((String)this.output.getName())));
        tooltips.add(twoColorC.apply("tooltip.appliedpneumatics.amadron_trade.input", ChatFormatting.YELLOW, (Component)Component.literal((String)this.input.getName())));
        tooltips.add(twoColorC.apply("tooltip.appliedpneumatics.amadron_trade.in_basket", ChatFormatting.AQUA, (Component)Component.literal((String)String.valueOf(Math.max(0, this.wantedStock)))));
        if (mc.options.advancedItemTooltips) {
            MutableComponent smallGray = Component.literal((String)("OfferID: " + String.valueOf(this.offerId))).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withFont(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"uniform")));
            tooltips.add(smallGray);
        }
        gui.renderTooltip(font, tooltips, Optional.empty(), mouseX - offsetX, mouseY - offsetY);
    }

    public boolean isMouseOverForTooltip(double mouseX, double mouseY) {
        return this.active && this.visible && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + this.width + 1) && mouseY < (double)(this.getY() + this.height + 1);
    }

    private static void drawAmadronTradeResourceTooltip(GuiGraphics gui, AmadronTradeResource resource, int mouseX, int mouseY) {
        ItemStack mayItem = resource.getItem();
        FluidStack mayFluid = resource.getFluid();
        if (!mayItem.isEmpty()) {
            gui.renderTooltip(Minecraft.getInstance().font, mayItem, mouseX, mouseY);
        } else if (!mayFluid.isEmpty()) {
            Font font = Minecraft.getInstance().font;
            ArrayList<Object> lines = new ArrayList<Object>(2);
            lines.add(mayFluid.getHoverName());
            lines.add(Component.literal((String)(mayFluid.getAmount() + " mB")).withStyle(ChatFormatting.GRAY));
            gui.renderTooltip(font, lines, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput out) {
    }

    public static interface onPress {
        public void onPress(int var1);
    }

    public record OfferType(boolean isStatic, boolean isVillager, boolean isPlayer) {
    }

    public record Bounds(int x, int y, int width, int height) {
    }

    @FunctionalInterface
    static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

