/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.BasicTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class BushTreeFeature
extends BOPTreeFeature<BasicTreeConfiguration> {
    public BushTreeFeature(Codec<BasicTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        BasicTreeConfiguration config = (BasicTreeConfiguration)configBase;
        while (startPos.getY() >= world.getMinBuildHeight() + 1 && (world.isEmptyBlock(startPos) || world.getBlockState(startPos).isAir())) {
            startPos = startPos.below();
        }
        if (!this.canReplace((LevelAccessor)world, startPos.above())) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        BlockPos pos = startPos.above();
        for (int y = 0; y < height; ++y) {
            if (height - y > 1) {
                this.placeLog((LevelAccessor)world, pos.offset(0, y, 0), logs, config);
            }
            int leavesRadius = height - y > 1 ? 2 : 1;
            for (int x = -leavesRadius; x <= leavesRadius; ++x) {
                for (int z = -leavesRadius; z <= leavesRadius; ++z) {
                    if (Math.abs(x) >= leavesRadius && Math.abs(z) >= leavesRadius && random.nextInt(2) == 0) continue;
                    if (config.altFoliageProvider.getState(random, pos) != Blocks.AIR.defaultBlockState()) {
                        if (random.nextInt(4) == 0) {
                            this.placeAltLeaves((LevelAccessor)world, pos.offset(x, y, z), leaves, config);
                            continue;
                        }
                        this.placeLeaves((LevelAccessor)world, pos.offset(x, y, z), leaves, config);
                        continue;
                    }
                    this.placeLeaves((LevelAccessor)world, pos.offset(x, y, z), leaves, config);
                }
            }
        }
        return true;
    }
}

