/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LeafPileBlock
extends BushBlock {
    public static final MapCodec<LeafPileBlock> CODEC = LeafPileBlock.simpleCodec(LeafPileBlock::new);
    protected static final VoxelShape NORMAL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);

    public LeafPileBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<LeafPileBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return NORMAL;
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        if (!worldIn.isClientSide && stack.getItem() == Items.SHEARS) {
            player.awardStat(Stats.BLOCK_MINED.get((Object)this));
            player.causeFoodExhaustion(0.005f);
            LeafPileBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
        } else {
            super.playerDestroy(worldIn, player, pos, state, te, stack);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState groundState = worldIn.getBlockState(pos.below());
        return groundState.isFaceSturdy((BlockGetter)worldIn, pos.below(), Direction.UP) || groundState.is(BlockTags.LEAVES) || super.canSurvive(state, worldIn, pos);
    }
}

