/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.integration.jei;

import com.google.common.base.Preconditions;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.ApiStatus;
import plus.dragons.createcentralkitchen.common.CCKCommon;
import plus.dragons.createdragonsplus.util.CodeReference;
import plus.dragons.createdragonsplus.util.ErrorMessages;

@JeiPlugin
public class CCKJeiPlugin
implements IModPlugin {
    public static final ResourceLocation ID = CCKCommon.asResource("jei");
    public final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    public static final RecipeType<RecipeHolder<FillingRecipe>> SPOUT_FILLING = RecipeType.createRecipeHolderType((ResourceLocation)Create.asResource((String)"spout_filling"));
    public static final RecipeType<RecipeHolder<EmptyingRecipe>> DRAINING = RecipeType.createRecipeHolderType((ResourceLocation)Create.asResource((String)"draining"));

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
    }

    private void loadCategories() {
        this.allCategories.clear();
    }

    @ApiStatus.Internal
    public static Level getLevel() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException("Retreiving client level is only supported for client");
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft, (Object)ErrorMessages.notNull((String)"minecraft"));
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level, (Object)ErrorMessages.notNull((String)"level"));
        return level;
    }

    @ApiStatus.Internal
    public static RecipeManager getRecipeManager() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException("Retreiving recipe manager from client level is only supported for client");
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft, (Object)ErrorMessages.notNull((String)"minecraft"));
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level, (Object)ErrorMessages.notNull((String)"level"));
        return level.getRecipeManager();
    }

    @CodeReference(source={"com.simibubi.create.compat.jei.CreateJEI"}, license={"mit"})
    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    @CodeReference(source={"com.simibubi.create.compat.jei.CreateJEI"}, license={"mit"})
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
    }

    @CodeReference(source={"com.simibubi.create.compat.jei.CreateJEI"}, license={"mit"})
    public <T extends Recipe<? extends RecipeInput>> CategoryBuilder<T> builder(Class<T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    @CodeReference(source={"com.simibubi.create.compat.jei.CreateJEI"}, license={"mit"})
    public class CategoryBuilder<T extends Recipe<?>>
    extends CreateRecipeCategory.Builder<T> {
        public CategoryBuilder(Class<? extends T> recipeClass) {
            super(recipeClass);
        }

        public CreateRecipeCategory<T> build(ResourceLocation id, CreateRecipeCategory.Factory<T> factory) {
            CreateRecipeCategory category = super.build(id, factory);
            CCKJeiPlugin.this.allCategories.add(category);
            return category;
        }
    }
}

