/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.integration.extradelight.mechanicalArm;

import com.lance5057.extradelight.ExtraDelightTags;
import com.lance5057.extradelight.workstations.chiller.ChillerBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ChillerArmInteractionPoint
extends ArmInteractionPoint {
    public ChillerArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    public ItemStack insert(ArmBlockEntity armBlockEntity, ItemStack stack, boolean simulate) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof ChillerBlockEntity) {
            ChillerBlockEntity interaction = (ChillerBlockEntity)blockEntity;
            ItemStackHandler inventory = interaction.getInventory();
            return inventory.insertItem(stack.is(ExtraDelightTags.CHILLING_ITEMS) ? 10 : 5, stack, simulate);
        }
        return stack;
    }

    public ItemStack extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof ChillerBlockEntity) {
            ChillerBlockEntity interaction = (ChillerBlockEntity)blockEntity;
            ItemStackHandler inventory = interaction.getInventory();
            return inventory.extractItem(6, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    public int getSlotCount(ArmBlockEntity armBlockEntity) {
        return 1;
    }

    public static class Type
    extends ArmInteractionPointType {
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return level.getBlockEntity(pos) instanceof ChillerBlockEntity;
        }

        @Nullable
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ChillerArmInteractionPoint(this, level, pos, state);
        }
    }
}

