/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.FluidMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public record SizedFluidIngredientComponent(RecipeComponentType<?> type, Codec<SizedFluidIngredient> codec, boolean allowEmpty) implements RecipeComponent<SizedFluidIngredient>
{
    public static final RecipeComponentType<SizedFluidIngredient> FLAT = RecipeComponentType.unit(KubeJS.id("flat_sized_fluid_ingredient"), type -> new SizedFluidIngredientComponent((RecipeComponentType<?>)type, (Codec<SizedFluidIngredient>)SizedFluidIngredient.FLAT_CODEC, false));
    public static final RecipeComponentType<SizedFluidIngredient> NESTED = RecipeComponentType.unit(KubeJS.id("nested_sized_fluid_ingredient"), type -> new SizedFluidIngredientComponent((RecipeComponentType<?>)type, (Codec<SizedFluidIngredient>)SizedFluidIngredient.NESTED_CODEC, false));
    public static final RecipeComponentType<SizedFluidIngredient> OPTIONAL_FLAT = RecipeComponentType.unit(KubeJS.id("optional_flat_sized_fluid_ingredient"), type -> new SizedFluidIngredientComponent((RecipeComponentType<?>)type, (Codec<SizedFluidIngredient>)SizedFluidIngredient.FLAT_CODEC, true));
    public static final RecipeComponentType<SizedFluidIngredient> OPTIONAL_NESTED = RecipeComponentType.unit(KubeJS.id("optional_nested_sized_fluid_ingredient"), type -> new SizedFluidIngredientComponent((RecipeComponentType<?>)type, (Codec<SizedFluidIngredient>)SizedFluidIngredient.NESTED_CODEC, true));

    @Override
    public TypeInfo typeInfo() {
        return FluidWrapper.SIZED_INGREDIENT_TYPE_INFO;
    }

    @Override
    public boolean hasPriority(RecipeMatchContext cx, Object from) {
        return from instanceof SizedFluidIngredient || from instanceof FluidIngredient || from instanceof FluidStack || from instanceof Fluid;
    }

    @Override
    public boolean matches(RecipeMatchContext cx, SizedFluidIngredient value, ReplacementMatchInfo match) {
        FluidMatch m;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof FluidMatch && (m = (FluidMatch)replacementMatch).matches(cx, value.ingredient(), match.exact());
    }

    @Override
    public boolean isEmpty(SizedFluidIngredient value) {
        return value.amount() <= 0 || value.ingredient().isEmpty();
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, SizedFluidIngredient value) {
        FluidStack[] stacks;
        if (!value.ingredient().isEmpty() && (stacks = value.ingredient().getStacks()).length > 0) {
            builder.append(stacks[0].getFluid().kjs$getIdLocation());
        }
    }

    @Override
    public String toString() {
        return this.type.toString();
    }
}

