/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.latvian.mods.kubejs.client.KubeJSClient;
import dev.latvian.mods.kubejs.script.data.GeneratedData;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;

public class KubeJSClientCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder cmd = (LiteralArgumentBuilder)Commands.literal((String)"kubejs").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reload").then(((LiteralArgumentBuilder)Commands.literal((String)"client-scripts").requires(source -> true)).executes(context -> KubeJSClientCommands.reloadClient((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"textures").requires(source -> true)).executes(context -> KubeJSClientCommands.reloadTextures((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"lang").requires(source -> true)).executes(context -> KubeJSClientCommands.reloadLang((CommandSourceStack)context.getSource()))));
        dispatcher.register(cmd);
    }

    private static int reloadClient(CommandSourceStack source) {
        KubeJSClient.reloadClientScripts();
        source.sendSystemMessage((Component)Component.literal((String)"Done! To reload textures, models and other assets, press F3 + T"));
        return 1;
    }

    private static int reloadTextures(CommandSourceStack source) {
        KubeJSClientCommands.reloadResources((PreparableReloadListener)Minecraft.getInstance().getTextureManager());
        return 1;
    }

    private static int reloadLang(CommandSourceStack source) {
        KubeJSClient.reloadClientScripts();
        KubeJSClientCommands.reloadResources((PreparableReloadListener)Minecraft.getInstance().getLanguageManager());
        return 1;
    }

    private static void reloadResources(PreparableReloadListener listener) {
        long start = System.currentTimeMillis();
        Minecraft mc = Minecraft.getInstance();
        mc.getResourceManager().getResource(GeneratedData.INTERNAL_RELOAD.id());
        listener.reload(CompletableFuture::completedFuture, mc.getResourceManager(), (ProfilerFiller)InactiveProfiler.INSTANCE, (ProfilerFiller)InactiveProfiler.INSTANCE, (Executor)Util.backgroundExecutor(), (Executor)mc).thenAccept(unused -> mc.player.sendSystemMessage((Component)Component.literal((String)"Done! You still may have to reload all assets with F3 + T")));
    }
}

