/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.integration.modules.jei.categories;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ItemModText;
import appeng.recipes.AERecipeTypes;
import appeng.recipes.transform.TransformRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import tamaized.ae2jeiintegration.integration.modules.jei.FluidBlockRenderer;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.AbstractCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.drawables.DrawableHelper;
import tamaized.ae2jeiintegration.integration.modules.jei.widgets.LabelWidget;

public class TransformCategory
extends AbstractCategory<RecipeHolder<TransformRecipe>> {
    public static final RecipeType<RecipeHolder<TransformRecipe>> RECIPE_TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)AERecipeTypes.TRANSFORM);
    private final FluidBlockRenderer fluidRenderer = new FluidBlockRenderer();
    private final IDrawableStatic unfilledArrow;

    public TransformCategory(IGuiHelper guiHelper) {
        super(guiHelper, (ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, (Component)ItemModText.TRANSFORM_CATEGORY.text(), (IDrawable)guiHelper.createBlankDrawable(130, 62));
        this.unfilledArrow = DrawableHelper.getUnfilledArrow(guiHelper);
    }

    public RecipeType<RecipeHolder<TransformRecipe>> getRecipeType() {
        return RECIPE_TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<TransformRecipe> holder, IFocusGroup focuses) {
        TransformRecipe recipe = (TransformRecipe)holder.value();
        int yOffset = 23;
        int y = 5;
        int x = 5;
        if (recipe.getIngredients().size() < 3) {
            y += (3 - recipe.getIngredients().size()) * 18 / 2;
        }
        for (Ingredient input : recipe.getIngredients()) {
            builder.addSlot(RecipeIngredientRole.INPUT, x + 1, y + 1).setStandardSlotBackground().addIngredients(input);
            if ((y += 18) < 54) continue;
            y -= 54;
            x += 18;
        }
        if (recipe.circumstance.isFluid()) {
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.CATALYST, 56, yOffset + 1);
            for (Fluid fluid : recipe.circumstance.getFluidsForRendering()) {
                if (!fluid.isSource(fluid.defaultFluidState())) continue;
                slot.addFluidStack(fluid);
            }
            slot.setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)this.fluidRenderer);
        } else if (recipe.circumstance.isExplosion()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 56, yOffset + 1).addItemStack(new ItemStack((ItemLike)Blocks.TNT))).addItemStack(AEBlocks.TINY_TNT.stack());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 106, yOffset + 1).setStandardSlotBackground().addItemStack(recipe.getResultItem());
    }

    public void draw(RecipeHolder<TransformRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int yOffset = 23;
        this.unfilledArrow.draw(guiGraphics, 25, yOffset);
        this.unfilledArrow.draw(guiGraphics, 76, yOffset);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<TransformRecipe> holder, IFocusGroup focuses) {
        TransformRecipe recipe = (TransformRecipe)holder.value();
        MutableComponent circumstance = recipe.circumstance.isExplosion() ? ItemModText.EXPLOSION.text() : ItemModText.SUBMERGE_IN.text();
        int x = this.background.getWidth() / 2;
        LabelWidget widget = new LabelWidget(x, 5, (Component)circumstance).bodyText();
        builder.addWidget((IRecipeWidget)widget);
    }

    public ResourceLocation getRegistryName(RecipeHolder<TransformRecipe> holder) {
        return holder.id();
    }
}

