/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.multiblock;

import com.brandon3055.brandonscore.multiblock.MultiBlockPart;
import com.brandon3055.brandonscore.multiblock.StructurePart;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockPart
implements MultiBlockPart {
    private final Block block;

    public BlockPart(ResourceLocation id) {
        if (!BuiltInRegistries.BLOCK.containsKey(id)) {
            throw new IllegalStateException("Specified block could not be found: " + String.valueOf(id));
        }
        this.block = (Block)BuiltInRegistries.BLOCK.get(id);
    }

    @Override
    public boolean isMatch(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof StructurePart) {
            return ((StructurePart)state.getBlock()).is(level, pos, this.block);
        }
        return state.is(this.block);
    }

    @Override
    public Collection<Block> validBlocks() {
        return Collections.singleton(this.block);
    }
}

