/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.LinkedList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;

@Deprecated
public class TeleportUtils {
    public static Entity teleportEntity(Entity entity, Entity destination) {
        return TeleportUtils.teleportEntity(entity, (ResourceKey<Level>)destination.level().dimension(), destination.getX(), destination.getY(), destination.zOld, destination.getYRot(), destination.getXRot());
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> dimension, double xCoord, double yCoord, double zCoord, float rotY, float rotX) {
        if (entity == null || entity.level().isClientSide) {
            return entity;
        }
        MinecraftServer server = entity.getServer();
        ResourceKey sourceDim = entity.level().dimension();
        if (!entity.isVehicle() && !entity.isPassenger()) {
            return TeleportUtils.handleEntityTeleport(entity, server, (ResourceKey<Level>)sourceDim, dimension, xCoord, yCoord, zCoord, rotY, rotX);
        }
        Entity rootEntity = entity.getRootVehicle();
        PassengerHelper passengerHelper = new PassengerHelper(rootEntity);
        PassengerHelper rider = passengerHelper.getPassenger(entity);
        if (rider == null) {
            LogHelperBC.error("RiddenEntity: This error should not be possible");
            return entity;
        }
        passengerHelper.teleport(server, (ResourceKey<Level>)sourceDim, dimension, xCoord, yCoord, zCoord, rotY, rotX);
        passengerHelper.remountRiders();
        passengerHelper.updateClients();
        return rider.entity;
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> dimension, Vector3 pos, float rotY, float rotX) {
        return TeleportUtils.teleportEntity(entity, dimension, pos.x, pos.y, pos.z, rotY, rotX);
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> dimension, double xCoord, double yCoord, double zCoord) {
        return TeleportUtils.teleportEntity(entity, dimension, xCoord, yCoord, zCoord, entity.getYRot(), entity.getXRot());
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> dimension, Vector3 pos) {
        return TeleportUtils.teleportEntity(entity, dimension, pos.x, pos.y, pos.z, entity.getYRot(), entity.getXRot());
    }

    private static Entity handleEntityTeleport(Entity entity, MinecraftServer server, ResourceKey<Level> sourceDim, ResourceKey<Level> targetDim, double xCoord, double yCoord, double zCoord, float rotY, float rotX) {
        boolean interDimensional;
        if (entity == null || entity.level().isClientSide || targetDim == null) {
            return entity;
        }
        boolean bl = interDimensional = sourceDim != targetDim;
        if (interDimensional && !CommonHooks.onTravelToDimension((Entity)entity, sourceDim)) {
            return entity;
        }
        if (interDimensional) {
            if (entity instanceof ServerPlayer) {
                return TeleportUtils.teleportPlayerInterdimentional((ServerPlayer)entity, server, targetDim, xCoord, yCoord, zCoord, rotY, rotX);
            }
            return TeleportUtils.teleportEntityInterdimentional(entity, server, targetDim, xCoord, yCoord, zCoord, rotY, rotX);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.connection.teleport(xCoord, yCoord, zCoord, rotY, rotX);
            player.setYHeadRot(rotY);
        } else {
            entity.moveTo(xCoord, yCoord, zCoord, rotY, rotX);
            entity.setYHeadRot(rotY);
        }
        return entity;
    }

    private static Entity teleportEntityInterdimentional(Entity entity, MinecraftServer server, ResourceKey<Level> targetDim, double xCoord, double yCoord, double zCoord, float rotY, float rotX) {
        ServerLevel targetWorld = server.getLevel(targetDim);
        if (!entity.isAlive() || targetWorld == null) {
            return null;
        }
        Entity movedEntity = entity.changeDimension(new DimensionTransition(targetWorld, new Vec3(xCoord, yCoord, zCoord), entity.getDeltaMovement(), rotY, rotX, DimensionTransition.DO_NOTHING));
        if (movedEntity != null) {
            return movedEntity;
        }
        entity.unRide();
        movedEntity = entity.getType().create((Level)targetWorld);
        if (movedEntity != null) {
            movedEntity.restoreFrom(entity);
            movedEntity.moveTo(xCoord, yCoord, zCoord, rotY, rotX);
            targetWorld.addDuringTeleport(movedEntity);
            entity.remove(Entity.RemovalReason.CHANGED_DIMENSION);
            ((ServerLevel)entity.level()).resetEmptyTime();
            targetWorld.resetEmptyTime();
            return movedEntity;
        }
        return entity;
    }

    private static Player teleportPlayerInterdimentional(ServerPlayer player, MinecraftServer server, ResourceKey<Level> targetDim, double xCoord, double yCoord, double zCoord, float rotY, float rotX) {
        ServerLevel targetWorld = server.getLevel(targetDim);
        if (!player.isAlive() || targetWorld == null) {
            return player;
        }
        player.isChangingDimension = true;
        player.teleportTo(targetWorld, xCoord, yCoord, zCoord, rotY, rotX);
        player.lastSentExp = -1;
        player.lastSentHealth = -1.0f;
        player.lastSentFood = -1;
        player.onUpdateAbilities();
        return player;
    }

    public static Entity getHighestRidingEntity(Entity mount) {
        Entity entity = mount;
        while (entity.getPassengers().size() > 0) {
            entity = (Entity)entity.getPassengers().get(0);
        }
        return entity;
    }

    private static class PassengerHelper {
        public Entity entity;
        public LinkedList<PassengerHelper> passengers = new LinkedList();
        public double offsetX;
        public double offsetY;
        public double offsetZ;

        public PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.isPassenger()) {
                this.offsetX = entity.getX() - entity.getVehicle().getX();
                this.offsetY = entity.getY() - entity.getVehicle().getY();
                this.offsetZ = entity.getZ() - entity.getVehicle().getZ();
            }
            for (Entity passenger : entity.getPassengers()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        public void teleport(MinecraftServer server, ResourceKey<Level> sourceDim, ResourceKey<Level> targetDim, double xCoord, double yCoord, double zCoord, float rotY, float rotX) {
            this.entity.ejectPassengers();
            this.entity = TeleportUtils.handleEntityTeleport(this.entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, rotY, rotX);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(server, sourceDim, targetDim, xCoord, yCoord, zCoord, rotY, rotX);
            }
        }

        public void remountRiders() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.isPassenger()) {
                this.entity.moveTo(this.entity.getX() + this.offsetX, this.entity.getY() + this.offsetY, this.entity.getZ() + this.offsetZ, this.entity.getYRot(), this.entity.getXRot());
            }
            for (PassengerHelper passenger : this.passengers) {
                DelayedTask.run(1, () -> passenger.entity.startRiding(this.entity, true));
                passenger.remountRiders();
            }
        }

        public void updateClients() {
            if (this.entity instanceof ServerPlayer) {
                this.updateClient((ServerPlayer)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(ServerPlayer playerMP) {
            if (this.entity.isVehicle()) {
                playerMP.connection.send((Packet)new ClientboundSetPassengersPacket(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        public PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

