/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.apps;

import earth.terrarium.tempad.api.app.TempadApp;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.common.apps.TimelineData;
import earth.terrarium.tempad.common.registries.ModAttachmentsKt;
import earth.terrarium.tempad.common.registries.ModMenus;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\u0019"}, d2={"Learth/terrarium/tempad/common/apps/TimelineApp;", "Learth/terrarium/tempad/api/app/TempadApp;", "Learth/terrarium/tempad/common/apps/TimelineData;", "ctx", "Learth/terrarium/tempad/api/context/SyncableContext;", "isStationary", "", "<init>", "(Learth/terrarium/tempad/api/context/SyncableContext;Z)V", "getCtx", "()Learth/terrarium/tempad/api/context/SyncableContext;", "()Z", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "pContainerId", "", "pPlayerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "createContent", "player", "Lnet/minecraft/server/level/ServerPlayer;", "tempad-1.21.1"})
public final class TimelineApp
implements TempadApp<TimelineData> {
    @NotNull
    private final SyncableContext<?> ctx;
    private final boolean isStationary;

    public TimelineApp(@NotNull SyncableContext<?> ctx2, boolean isStationary) {
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        this.ctx = ctx2;
        this.isStationary = isStationary;
    }

    @NotNull
    public final SyncableContext<?> getCtx() {
        return this.ctx;
    }

    public final boolean isStationary() {
        return this.isStationary;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayerInventory, (String)"pPlayerInventory");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Optional<TimelineData> optional = Optional.of(this.createContent((ServerPlayer)pPlayer));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return new ModMenus.TimelineMenu(pContainerId, pPlayerInventory, optional);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = Component.translatable((String)"app.tempad.timeline");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public TimelineData createContent(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new TimelineData(ModAttachmentsKt.getTravelHistory((AttachmentHolder)player), this.isStationary, this.ctx.getHolder());
    }
}

