/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardtype;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.SchematicPart;
import chanceCubes.rewards.rewardtype.IRewardType;
import chanceCubes.util.CustomSchematic;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.Level;

public class SchematicRewardType
implements IRewardType {
    private final SchematicPart part;

    public SchematicRewardType(SchematicPart part) {
        this.part = part;
    }

    @Override
    public void trigger(final ServerLevel level, final int x, final int y, final int z, final Player player) {
        final CustomSchematic schematic = this.part.getSchematic();
        if (schematic == null) {
            CCubesCore.logger.log(Level.ERROR, "Failed to load a schematic reward with the file name " + this.part.getFileName());
            return;
        }
        final ArrayList<OffsetBlock> stack = new ArrayList<OffsetBlock>();
        for (OffsetBlock osb : schematic.getBlocks()) {
            if (!schematic.includeAirBlocks() && osb.getBlockState().getBlock().equals(Blocks.AIR)) continue;
            stack.add(osb);
        }
        Scheduler.scheduleTask(new Task(this, "Schematic_Spawn_Delay", schematic.getDelay()){

            @Override
            public void callback() {
                final double playerX = player.getX();
                final double playerY = player.getY();
                final double playerZ = player.getZ();
                Scheduler.scheduleTask(new Task("Schematic_Reward_Block_Spawn", -1, schematic.getSpacingDelay() < 1.0f ? 1 : (int)schematic.getSpacingDelay()){

                    @Override
                    public void callback() {
                    }

                    @Override
                    public void update() {
                        float lessThan1 = 0.0f;
                        while (lessThan1 < 1.0f && !stack.isEmpty()) {
                            OffsetBlock osb = (OffsetBlock)stack.remove(0);
                            if (schematic.isRelativeToPlayer()) {
                                pos = new BlockPos((int)Math.floor(playerX) + osb.xOff.getIntValue(), (int)Math.floor(playerY) + osb.yOff.getIntValue(), (int)Math.floor(playerZ) + osb.zOff.getIntValue());
                                if (level.getBlockState(pos).isAir() && osb.getBlockState().getBlock() instanceof AirBlock) continue;
                                osb.spawnInWorld((net.minecraft.world.level.Level)level, (int)Math.floor(playerX), (int)Math.floor(playerY), (int)Math.floor(playerZ));
                            } else {
                                pos = new BlockPos(x + osb.xOff.getIntValue(), y + osb.yOff.getIntValue(), z + osb.zOff.getIntValue());
                                if (level.getBlockState(pos).isAir() && osb.getBlockState().getBlock() instanceof AirBlock) continue;
                                osb.spawnInWorld((net.minecraft.world.level.Level)level, x, y, z);
                            }
                            lessThan1 += schematic.getSpacingDelay();
                            if (stack.size() != 0) continue;
                            lessThan1 = 1.0f;
                        }
                        if (stack.size() == 0) {
                            Scheduler.removeTask(this);
                        }
                    }
                });
            }
        });
    }
}

