/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class RandomExplosionReward
extends BaseCustomReward {
    public RandomExplosionReward() {
        super("chancecubes:random_explosion", 0);
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, Player player, JsonObject settings) {
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
        Scheduler.scheduleTask(new Task(this, "Random Explosion", 300, 2){
            int delay;
            int count;
            {
                super(name, delay, updateTick);
                this.delay = 12;
                this.count = 0;
            }

            @Override
            public void callback() {
                RewardsUtil.placeBlock(Blocks.AIR.defaultBlockState(), (Level)level, pos);
                int rand = RewardsUtil.rand.nextInt(6);
                for (double xx = 1.0; xx > -1.0; xx -= 0.25) {
                    for (double zz = 1.0; zz > -1.0; zz -= 0.25) {
                        Entity ent;
                        if (rand == 0) {
                            ent = EntityType.CREEPER.create((Level)level);
                        } else if (rand == 1) {
                            ent = EntityType.TNT.create((Level)level);
                        } else if (rand == 2) {
                            ent = EntityType.ITEM.create((Level)level);
                            ((ItemEntity)ent).setItem(new ItemStack((ItemLike)Items.DIAMOND));
                        } else if (rand == 3) {
                            ent = EntityType.ITEM.create((Level)level);
                            ((ItemEntity)ent).setItem(new ItemStack((ItemLike)Items.MELON_SLICE));
                        } else {
                            ent = rand == 4 ? EntityType.BAT.create((Level)level) : EntityType.ZOMBIE.create((Level)level);
                        }
                        ent.moveTo((double)pos.getX(), (double)pos.getY() + 1.0, (double)pos.getZ());
                        level.addFreshEntity(ent);
                        ent.setDeltaMovement(xx, Math.random(), zz);
                    }
                }
            }

            @Override
            public void update() {
                ++this.count;
                if (this.count >= this.delay) {
                    if (this.delay > 2) {
                        --this.delay;
                    }
                    this.count = 0;
                    int xInc = RewardsUtil.rand.nextInt(2) * (RewardsUtil.rand.nextBoolean() ? -1 : 1);
                    int yInc = RewardsUtil.rand.nextInt(2) * (RewardsUtil.rand.nextBoolean() ? -1 : 1);
                    int zInc = RewardsUtil.rand.nextInt(2) * (RewardsUtil.rand.nextBoolean() ? -1 : 1);
                    if (this.delay < 3) {
                        level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, (double)pos.getX() + 0.5 + (double)xInc, (double)pos.getY() + 0.5 + (double)yInc, (double)pos.getZ() + 0.5 + (double)zInc, 3, 0.0, 0.0, 0.0, 0.125);
                        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        if (RewardsUtil.rand.nextBoolean()) {
                            level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                        } else {
                            level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BLAZE_HURT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        level.sendParticles((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5 + (double)xInc, (double)pos.getY() + 0.5 + (double)yInc, (double)pos.getZ() + 0.5 + (double)zInc, 5, 0.0, 0.0, 0.0, 0.125);
                    }
                }
            }
        });
    }
}

