/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.config.ConfigLoader;
import chanceCubes.mcwrapper.BlockWrapper;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.mcwrapper.EntityWrapper;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardtype.BlockRewardType;
import chanceCubes.rewards.rewardtype.EntityRewardType;
import chanceCubes.rewards.rewardtype.ItemRewardType;
import chanceCubes.rewards.rewardtype.MessageRewardType;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class WheelSpinReward
extends BaseCustomReward {
    private static final List<RewardTrigger> rewards = new ArrayList<RewardTrigger>();
    private final RewardTrigger[] rewardsChosen = new RewardTrigger[4];

    public WheelSpinReward(HolderLookup.Provider provider) {
        super("chancecubes:wheel_spin", 10);
        rewards.add(new RewardTrigger(new BasicReward("diamond", 0, new ItemRewardType(new ItemPart(new ItemStack((ItemLike)Items.DIAMOND, 1), provider))), "", "1 Diamond"));
        rewards.add(new RewardTrigger(new BasicReward("creeper", 0, new EntityRewardType("creeper")), "", "Creeper"));
        rewards.add(new RewardTrigger(new BaseCustomReward(this, "tnt", 0){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (int i = 0; i < 5; ++i) {
                    PrimedTnt entitytntprimed = new PrimedTnt((Level)level, player.getX(), player.getY() + 1.0, player.getZ(), (LivingEntity)player);
                    level.addFreshEntity((Entity)entitytntprimed);
                    level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    entitytntprimed.setFuse(140);
                }
            }
        }, "", "TNT"));
        rewards.add(new RewardTrigger(new BasicReward("diamond_cooking", 0, new ItemRewardType(new ItemPart(new ItemStack((ItemLike)Items.COAL_BLOCK, 1), provider)), new MessageRewardType("Sorry, your diamond wasn't done cooking! :(")), "", "1 Diamond?"));
        rewards.add(new RewardTrigger(new BaseCustomReward(this, "random_reward_neutral", 0){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                GlobalCCRewardRegistry.DEFAULT.triggerRandomReward(level, pos, player, 0);
            }
        }, "Random", "chance Cube", "Reward", "Value: 0"));
        rewards.add(new RewardTrigger(new BaseCustomReward(this, "random_reward_bad", 0){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                GlobalCCRewardRegistry.DEFAULT.triggerRandomReward(level, pos, player, -50);
            }
        }, "Random", "chance Cube", "Reward", "Value: -50"));
        rewards.add(new RewardTrigger(new BaseCustomReward(this, "random_reward_good", 0){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                GlobalCCRewardRegistry.DEFAULT.triggerRandomReward(level, pos, player, 50);
            }
        }, "Random", "chance Cube", "Reward", "Value: 50"));
        rewards.add(new RewardTrigger(new BasicReward("emerald", 0, new ItemRewardType(new ItemPart(new ItemStack((ItemLike)Items.EMERALD, 1), provider))), "", "1 Emerald"));
        rewards.add(new RewardTrigger(new BasicReward("nothing", 0, new MessageRewardType("Congrats! You won absolutely nothing!")), "", "Nothing"));
        ItemStack car = new ItemStack((ItemLike)Items.MINECART);
        car.set(DataComponents.CUSTOM_NAME, (Object)ComponentWrapper.string("New Car!"));
        car.enchant(provider.holderOrThrow(Enchantments.UNBREAKING), 0);
        rewards.add(new RewardTrigger(new BasicReward("new_car", 0, new ItemRewardType(new ItemPart(car, provider))), "", "A Brand", "New Car"));
        rewards.add(new RewardTrigger(new BasicReward("lava", 0, new BlockRewardType(new OffsetBlock(0, 0, 0, Blocks.LAVA, false))), "", "Hot Stuff"));
        rewards.add(new RewardTrigger(new BaseCustomReward(this, "vacation", 0){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                int xChange = RewardsUtil.rand.nextInt(50) + 20 + pos.getX() - 35;
                int zChange = RewardsUtil.rand.nextInt(50) + 20 + pos.getZ() - 35;
                int yChange = -1;
                for (int yy = 0; yy <= level.getHeight(); ++yy) {
                    if (!level.getBlockState(new BlockPos(xChange, yy, zChange)).isAir() || !level.getBlockState(new BlockPos(xChange, yy + 1, zChange)).isAir()) continue;
                    yChange = yy;
                    break;
                }
                if (yChange == -1) {
                    return;
                }
                player.moveTo((double)xChange, (double)yChange, (double)zChange);
            }
        }, "All", "Expenses", "Paid", "Vacation"));
        rewards.add(new RewardTrigger(new BasicReward("free_groceries", 0, new ItemRewardType(new ItemPart(new ItemStack((ItemLike)Items.BREAD, 64), provider), new ItemPart(new ItemStack((ItemLike)Items.COOKIE, 64), provider), new ItemPart(new ItemStack((ItemLike)Items.MILK_BUCKET, 10), provider)), new MessageRewardType("There, that should last you a year!")), "", "Free Groceries", "For a YEAR!"));
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, final Player player, JsonObject settings) {
        final ArmorStand armorStand = (ArmorStand)EntityWrapper.spawnEntityAt(EntityType.ARMOR_STAND, (Level)level, (double)pos.getX() + 0.8, (double)pos.getY() + 1.15, (double)pos.getZ() + 1.5);
        armorStand.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.ORANGE_BANNER));
        armorStand.setRightArmPose(new Rotations(90.0f, 0.0f, 0.0f));
        armorStand.setInvisible(true);
        armorStand.setNoGravity(true);
        this.rewardsChosen[0] = rewards.get(RewardsUtil.rand.nextInt(rewards.size()));
        this.rewardsChosen[1] = rewards.get(RewardsUtil.rand.nextInt(rewards.size()));
        this.rewardsChosen[2] = rewards.get(RewardsUtil.rand.nextInt(rewards.size()));
        this.rewardsChosen[3] = rewards.get(RewardsUtil.rand.nextInt(rewards.size()));
        final RewardBlockCache cache = new RewardBlockCache((Level)level, pos, player.getOnPos());
        BlockState bc = Blocks.BLACK_CONCRETE.defaultBlockState();
        BlockState wc = Blocks.WHITE_CONCRETE.defaultBlockState();
        BlockState lbc = Blocks.LIGHT_BLUE_CONCRETE.defaultBlockState();
        BlockState ss = (BlockState)Blocks.OAK_WALL_SIGN.defaultBlockState().setValue((Property)WallSignBlock.FACING, (Comparable)Direction.SOUTH);
        BlockPos offset = new BlockPos(0, 0, 1);
        cache.cacheBlock(offset, ss);
        BlockEntity be = level.getBlockEntity(pos.offset((Vec3i)offset));
        BlockWrapper.setSignText(be, this.rewardsChosen[0].signText);
        offset = new BlockPos(-2, 2, 1);
        cache.cacheBlock(offset, ss);
        be = level.getBlockEntity(pos.offset((Vec3i)offset));
        BlockWrapper.setSignText(be, this.rewardsChosen[1].signText);
        offset = new BlockPos(2, 2, 1);
        cache.cacheBlock(offset, ss);
        be = level.getBlockEntity(pos.offset((Vec3i)offset));
        BlockWrapper.setSignText(be, this.rewardsChosen[3].signText);
        offset = new BlockPos(0, 4, 1);
        cache.cacheBlock(offset, ss);
        be = level.getBlockEntity(pos.offset((Vec3i)offset));
        BlockWrapper.setSignText(be, this.rewardsChosen[2].signText);
        offset = new BlockPos(4, 1, 1);
        cache.cacheBlock(offset, ss);
        be = level.getBlockEntity(pos.offset((Vec3i)offset));
        BlockWrapper.setSignText(be, new String[]{"Pull", "To Spin", "The Wheel!"});
        final BlockPos leverOffset = new BlockPos(4, 0, 1);
        cache.cacheBlock(leverOffset, (BlockState)Blocks.LEVER.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH));
        cache.cacheBlock(new BlockPos(4, 1, 0), wc);
        cache.cacheBlock(new BlockPos(4, 0, 0), wc);
        cache.cacheBlock(new BlockPos(-1, 4, 0), bc);
        cache.cacheBlock(new BlockPos(0, 4, 0), bc);
        cache.cacheBlock(new BlockPos(1, 4, 0), bc);
        cache.cacheBlock(new BlockPos(-2, 3, 0), lbc);
        cache.cacheBlock(new BlockPos(-1, 3, 0), bc);
        cache.cacheBlock(new BlockPos(0, 3, 0), bc);
        cache.cacheBlock(new BlockPos(1, 3, 0), lbc);
        cache.cacheBlock(new BlockPos(2, 3, 0), lbc);
        cache.cacheBlock(new BlockPos(-2, 2, 0), lbc);
        cache.cacheBlock(new BlockPos(-1, 2, 0), lbc);
        cache.cacheBlock(new BlockPos(0, 2, 0), wc);
        cache.cacheBlock(new BlockPos(1, 2, 0), lbc);
        cache.cacheBlock(new BlockPos(2, 2, 0), lbc);
        cache.cacheBlock(new BlockPos(-2, 1, 0), lbc);
        cache.cacheBlock(new BlockPos(-1, 1, 0), lbc);
        cache.cacheBlock(new BlockPos(0, 1, 0), bc);
        cache.cacheBlock(new BlockPos(1, 1, 0), bc);
        cache.cacheBlock(new BlockPos(2, 1, 0), lbc);
        cache.cacheBlock(new BlockPos(-1, 0, 0), bc);
        cache.cacheBlock(new BlockPos(0, 0, 0), bc);
        cache.cacheBlock(new BlockPos(1, 0, 0), bc);
        Scheduler.scheduleTask(new Task("wheel_spin_lever_task", 600, 1){
            final BlockPos leverPos;
            {
                super(name, delay, updateTick);
                this.leverPos = pos.offset((Vec3i)leverOffset);
            }

            @Override
            public void callback() {
                cache.restoreBlocks(null);
                armorStand.remove(Entity.RemovalReason.DISCARDED);
            }

            @Override
            public void update() {
                BlockState state = level.getBlockState(this.leverPos);
                if (!state.getBlock().equals(Blocks.LEVER)) {
                    level.setBlockAndUpdate(this.leverPos, Blocks.LEVER.defaultBlockState());
                } else if (((Boolean)state.getValue((Property)LeverBlock.POWERED)).booleanValue()) {
                    WheelSpinReward.this.spinWheel(level, pos, armorStand, cache, player);
                    Scheduler.removeTask(this);
                }
            }
        });
    }

    public void spinWheel(final ServerLevel level, final BlockPos pos, final ArmorStand armorStand, final RewardBlockCache cache, final Player player) {
        final int rewardPicked = RewardsUtil.rand.nextInt(4);
        int delayBase = 194 + rewardPicked * 6 - 1;
        Scheduler.scheduleTask(new Task("wheel_spin_task", delayBase, 1){
            float rotIndex;
            {
                super(name, delay, updateTick);
                this.rotIndex = 0.0f;
            }

            @Override
            public void callback() {
                WheelSpinReward.this.endDelay(level, pos, armorStand, cache, player, rewardPicked);
            }

            @Override
            public void update() {
                this.rotIndex += 15.0f;
                armorStand.setRightArmPose(new Rotations(90.0f, 0.0f, this.rotIndex));
                if (this.rotIndex % 30.0f == 0.0f) {
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        });
    }

    public void endDelay(final ServerLevel level, final BlockPos pos, final ArmorStand armorStand, final RewardBlockCache cache, final Player player, final int rewardPicked) {
        Scheduler.scheduleTask(new Task("wheel_spin_end_task", 60){

            @Override
            public void callback() {
                armorStand.remove(Entity.RemovalReason.DISCARDED);
                cache.restoreBlocks((Entity)player);
                BaseCustomReward reward = WheelSpinReward.this.rewardsChosen[rewardPicked].reward;
                JsonObject settingsJson = ConfigLoader.getRewardSettings(reward.getName());
                reward.trigger(level, pos, player, settingsJson);
            }
        });
    }

    private static class RewardTrigger {
        public final String[] signText;
        public final BaseCustomReward reward;

        public RewardTrigger(BaseCustomReward reward, String ... lines) {
            this.reward = reward;
            this.signText = lines;
        }
    }
}

