/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;

public class LootBoxReward
extends BaseCustomReward {
    private static final String COMMON_LORE = "{\"text\":\"Common\",\"color\":\"white\",\"bold\":true}";
    private static final String UNCOMMON_LORE = "{\"text\":\"Uncommon\",\"color\":\"green\",\"bold\":true}";
    private static final String RARE_LORE = "{\"text\":\"Rare\",\"color\":\"blue\",\"bold\":true}";
    private static final String LEGENDARY_LORE = "{\"text\":\"Legendary\",\"color\":\"red\",\"bold\":true}";
    private static final String EPIC_LORE = "{\"text\":\"Epic\",\"color\":\"dark_purple\",\"bold\":true}";
    private static final String SHINY_LORE = "{\"text\":\"SHINY!\",\"color\":\"aqua\",\"italic\":true}";
    public static final List<ItemStack> COMMON = new ArrayList<ItemStack>();
    public static final List<ItemStack> UNCOMMON = new ArrayList<ItemStack>();
    public static final List<ItemStack> RARE = new ArrayList<ItemStack>();
    public static final List<ItemStack> LEGENDARY = new ArrayList<ItemStack>();
    public static final List<ItemStack> EPIC = new ArrayList<ItemStack>();

    public LootBoxReward() {
        super("chancecubes:loot_box", 35);
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, Player player, JsonObject settings) {
        level.setBlockAndUpdate(pos, Blocks.BEDROCK.defaultBlockState());
        Scheduler.scheduleTask(new Task("CC_Loot_Box_Animation", -1, 1){
            int tick;
            double y;
            double inc;
            {
                super(name, delay, updateTick);
                this.tick = 0;
                this.y = 0.0;
                this.inc = 0.023;
            }

            @Override
            public void callback() {
                RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 25, "Open the Chance Cubes Loot Box to get some collectibles!");
                level.setBlockAndUpdate(pos, Blocks.CHEST.defaultBlockState());
                BlockEntity te = level.getBlockEntity(pos);
                if (!(te instanceof ChestBlockEntity)) {
                    return;
                }
                ChestBlockEntity chest = (ChestBlockEntity)te;
                for (int i = 0; i < 10; ++i) {
                    chest.setItem(i, LootBoxReward.this.getCollectible());
                }
            }

            @Override
            public void update() {
                if (this.tick < 250) {
                    this.y += this.inc;
                    if (this.y > 1.0 || this.y < 0.0) {
                        this.inc *= -1.0;
                    }
                    double xOff = Math.cos((float)this.tick / 3.0f);
                    double yOff = Math.sin((float)this.tick / 3.0f);
                    level.sendParticles((ParticleOptions)ParticleTypes.DRIPPING_LAVA, (double)pos.getX() + xOff + 0.5, (double)pos.getY() + this.y, (double)pos.getZ() + yOff + 0.5, 3, 0.0, 0.0, 0.0, (double)0.15f);
                    level.sendParticles((ParticleOptions)ParticleTypes.DRIPPING_LAVA, (double)pos.getX() - xOff + 0.5, (double)pos.getY() + this.y, (double)pos.getZ() - yOff + 0.5, 3, 0.0, 0.0, 0.0, (double)0.15f);
                }
                if (this.tick == 250) {
                    for (int i = 0; i < 100; ++i) {
                        level.sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, (double)pos.getX() + 0.5, (double)pos.getY() + 0.95, (double)pos.getZ() + 0.5, 3, 0.0, 0.0, 0.0, (double)0.15f);
                    }
                }
                if (this.tick > 250) {
                    this.callback();
                    Scheduler.removeTask(this);
                }
                ++this.tick;
            }
        });
    }

    public ItemStack getCollectible() {
        int rarity = RewardsUtil.rand.nextInt(100);
        ItemStack stack = rarity < 50 ? COMMON.get(RewardsUtil.rand.nextInt(COMMON.size())).copy() : (rarity < 80 ? UNCOMMON.get(RewardsUtil.rand.nextInt(UNCOMMON.size())).copy() : (rarity < 93 ? RARE.get(RewardsUtil.rand.nextInt(RARE.size())).copy() : (rarity < 99 ? LEGENDARY.get(RewardsUtil.rand.nextInt(LEGENDARY.size())).copy() : EPIC.get(RewardsUtil.rand.nextInt(EPIC.size())).copy())));
        if (RewardsUtil.rand.nextInt(100) == 42) {
            ItemLore lore = ((ItemLore)stack.getOrDefault(DataComponents.LORE, (Object)ItemLore.EMPTY)).withLineAdded((Component)Component.literal((String)SHINY_LORE));
            stack.set(DataComponents.LORE, (Object)lore);
        }
        return stack;
    }

    private static ItemStack addItem(List<ItemStack> list, Item item, String lore) {
        ItemStack stack = new ItemStack((ItemLike)item, 1);
        stack.set(DataComponents.LORE, (Object)ItemLore.EMPTY.withLineAdded((Component)Component.literal((String)lore)));
        list.add(stack);
        return stack;
    }

    static {
        LootBoxReward.addItem(COMMON, Items.LEATHER_CHESTPLATE, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.COAL, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.STICK, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.BRICK, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.FEATHER, COMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.IRON_SWORD, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.APPLE, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.FLINT_AND_STEEL, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.ARROW, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.STRING, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.WHEAT, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.BONE, UNCOMMON_LORE);
        LootBoxReward.addItem(RARE, Items.DIAMOND, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.CHAINMAIL_HELMET, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.CHAINMAIL_BOOTS, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.CLOCK, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.IRON_NUGGET, RARE_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.TURTLE_HELMET, LEGENDARY_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.NETHERITE_LEGGINGS, LEGENDARY_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.DIAMOND_CHESTPLATE, LEGENDARY_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.GHAST_TEAR, LEGENDARY_LORE);
        LootBoxReward.addItem(EPIC, Items.SPECTRAL_ARROW, EPIC_LORE);
        LootBoxReward.addItem(EPIC, Items.CLAY_BALL, EPIC_LORE);
    }
}

