/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.mcwrapper.EntityWrapper;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class CakeIsALieReward
extends BaseCustomReward {
    public CakeIsALieReward() {
        super("chancecubes:cake", 20);
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, final Player player, JsonObject settings) {
        RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 32, "But is it a lie?");
        RewardsUtil.placeBlock(Blocks.CAKE.defaultBlockState(), (Level)level, pos);
        final int lieChance = super.getSettingAsInt(settings, "lieChance", 10, 0, 100);
        if (RewardsUtil.rand.nextInt(3) == 1) {
            Scheduler.scheduleTask(new Task(this, "Cake_Is_A_Lie", 6000, 20){

                @Override
                public void callback() {
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                }

                @Override
                public void update() {
                    if (!level.getBlockState(pos).getBlock().equals(Blocks.CAKE)) {
                        Scheduler.removeTask(this);
                    } else if ((Integer)level.getBlockState(pos).getValue((Property)CakeBlock.BITES) > 0) {
                        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 32, "It's a lie!!!");
                        Creeper creeper = (Creeper)EntityType.CREEPER.create((Level)level);
                        creeper.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), pos.getX() == 1 ? 90.0f : -90.0f, 0.0f);
                        if (RewardsUtil.rand.nextInt(100) < lieChance) {
                            EntityWrapper.setCreeperPowered(creeper);
                        }
                        creeper.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 9999, 2));
                        creeper.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 60, 999));
                        level.addFreshEntity((Entity)creeper);
                        RewardsUtil.executeCommand(level, player, (Vec3i)player.getOnPos(), "/advancement grant @p only chancecubes:its_a_lie");
                        Scheduler.removeTask(this);
                    }
                }
            });
        }
    }
}

