/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BossSlimeQueenReward
extends BossBaseReward {
    public BossSlimeQueenReward() {
        super("slime_queen");
    }

    @Override
    public LivingEntity initBoss(ServerLevel level, BlockPos pos, Player player, JsonObject settings, BossBaseReward.BattleWrapper battleWrapper) {
        Slime queen = (Slime)EntityType.SLIME.create((Level)level);
        queen.setCustomName((Component)ComponentWrapper.string("Slime Queen"));
        CompoundTag nbt = new CompoundTag();
        queen.save(nbt);
        nbt.putInt("Size", 10);
        queen.load(nbt);
        queen.addEffect(new MobEffectInstance(MobEffects.GLOWING, Integer.MAX_VALUE, 0, true, false));
        return queen;
    }

    @Override
    public void onBossFightEnd(final ServerLevel level, final BlockPos pos, Player player) {
        CCubesCore.logger.log(org.apache.logging.log4j.Level.INFO, "End Fight!");
        Scheduler.scheduleTask(new Task(this, "boss_fight_slime_queen_kill_all", 200, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                List slimes = level.getEntities((EntityTypeTest)EntityType.SLIME, new AABB(Vec3.atLowerCornerOf((Vec3i)pos.offset(-25, -25, -25)), Vec3.atLowerCornerOf((Vec3i)pos.offset(25, 25, 25))), EntitySelector.NO_SPECTATORS);
                CCubesCore.logger.log(org.apache.logging.log4j.Level.INFO, (Object)slimes.size());
                for (Slime slime : slimes) {
                    slime.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        });
    }
}

