/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.network;

import chanceCubes.CCubesCore;
import chanceCubes.components.CCubesDataComponents;
import chanceCubes.containers.CreativePendantContainer;
import chanceCubes.items.CCubesItems;
import chanceCubes.items.ItemChanceCube;
import chanceCubes.network.PacketCreativePendant;
import chanceCubes.network.PacketCubeScan;
import chanceCubes.network.PacketRewardSelector;
import chanceCubes.tileentities.TileChanceCube;
import chanceCubes.tileentities.TileChanceD20;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CCubesServerPayloadHandler {
    private static final CCubesServerPayloadHandler INSTANCE = new CCubesServerPayloadHandler();

    public static CCubesServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleCreativePendant(PacketCreativePendant msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player == null) {
                return;
            }
            try {
                CreativePendantContainer container;
                ItemStack cCubes;
                AbstractContainerMenu c = player.containerMenu;
                if (c instanceof CreativePendantContainer && !(cCubes = (container = (CreativePendantContainer)c).getChanceCubesInPendant()).isEmpty() && cCubes.getItem() instanceof ItemChanceCube) {
                    ((ItemChanceCube)cCubes.getItem()).setChance(cCubes, msg.chanceValue());
                }
            }
            catch (Exception e) {
                CCubesCore.logger.error("Chance Cubes has failed to set the chance of a cube due to a packet failure! Please Inform Turkey of this!");
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"chancecubes.networking.creative_pendant.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleRewardSelector(PacketRewardSelector msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player == null) {
                return;
            }
            ItemStack stack = player.getInventory().getSelected();
            if (!stack.isEmpty() && (stack.getItem().equals(CCubesItems.REWARD_SELECTOR_PENDANT.get()) || stack.getItem().equals(CCubesItems.SINGLE_USE_REWARD_SELECTOR_PENDANT.get()))) {
                stack.set(CCubesDataComponents.REWARD, (Object)msg.reward());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"chancecubes.networking.reward_selector.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleCubeScan(PacketCubeScan msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player == null) {
                return;
            }
            Level level = player.level();
            BlockEntity te = level.getBlockEntity(msg.pos());
            if (te instanceof TileChanceCube) {
                ((TileChanceCube)te).setScanned(true);
            } else if (te instanceof TileChanceD20) {
                ((TileChanceD20)te).setScanned(true);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"chancecubes.networking.cube_scan.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

