/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.mcwrapper;

import chanceCubes.mcwrapper.ComponentWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityWrapper {
    public static void spawnLightning(Level level, BlockPos pos) {
        LightningBolt lightningBoltEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
        if (lightningBoltEntity == null) {
            return;
        }
        lightningBoltEntity.moveTo(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
        lightningBoltEntity.setVisualOnly(false);
        level.addFreshEntity((Entity)lightningBoltEntity);
    }

    public static void setCreeperPowered(Creeper creeper) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("powered", true);
        creeper.readAdditionalSaveData(tag);
    }

    public static <T extends Entity> T spawnEntity(EntityType<T> type, Level level) {
        Entity ent = type.create(level);
        if (ent != null) {
            level.addFreshEntity(ent);
        }
        return (T)ent;
    }

    public static <T extends Entity> T spawnEntityAt(EntityType<T> type, Level level, BlockPos pos) {
        return EntityWrapper.spawnEntityAt(type, level, pos.getX(), pos.getY(), pos.getZ());
    }

    public static <T extends Entity> T spawnEntityAt(EntityType<T> type, Level level, double x, double y, double z) {
        T ent = EntityWrapper.spawnEntity(type, level);
        if (ent != null) {
            ent.moveTo(x, y, z, 0.0f, 0.0f);
        }
        return ent;
    }

    public static <T extends Entity> T spawnNamedEntityAt(EntityType<T> type, Level level, String name, BlockPos pos) {
        return EntityWrapper.spawnNamedEntityAt(type, level, name, pos.getX(), pos.getY(), pos.getZ());
    }

    public static <T extends Entity> T spawnNamedEntityAt(EntityType<T> type, Level level, String name, double x, double y, double z) {
        T ent = EntityWrapper.spawnEntityAt(type, level, x, y, z);
        if (ent != null) {
            ent.setCustomName((Component)ComponentWrapper.string(name));
        }
        return ent;
    }

    public static <T extends Entity> void spawnPrimedTNT(Level level, BlockPos pos, int fuse) {
        PrimedTnt tnt = (PrimedTnt)EntityWrapper.spawnEntityAt(EntityType.TNT, level, pos);
        if (tnt != null) {
            tnt.setFuse(fuse);
        }
    }

    public static <T extends Entity> void spawnChargedCreeper(Level level, BlockPos pos) {
        Creeper ent = (Creeper)EntityWrapper.spawnEntityAt(EntityType.CREEPER, level, pos);
        if (ent != null) {
            EntityWrapper.setCreeperPowered(ent);
        }
    }
}

