/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.items;

import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.components.CCubesDataComponents;
import chanceCubes.items.CCubesItems;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.tileentities.TileChanceCube;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ItemChanceCube
extends BlockItem {
    public ItemChanceCube(BaseChanceBlock b) {
        super((Block)b, ItemChanceCube.getProps(b));
    }

    public static Item.Properties getProps(Block b) {
        Item.Properties props = new Item.Properties();
        if (!b.equals(CCubesBlocks.GIANT_CUBE.get())) {
            // empty if block
        }
        return props;
    }

    public void setChance(ItemStack stack, int chance) {
        if (chance > 100 || chance < -101) {
            chance = -101;
        }
        stack.set(CCubesDataComponents.CHANCE, (Object)chance);
    }

    public int getChance(ItemStack stack) {
        return (Integer)stack.getOrDefault(CCubesDataComponents.CHANCE, (Object)-101);
    }

    public String getChanceAsStringValue(ItemStack stack) {
        int chance = this.getChance(stack);
        return chance == -101 ? "Random" : String.valueOf(chance);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        Item item = stack.getItem();
        if (!item.equals(CCubesItems.CUBE_DISPENSER.get())) {
            String chance = this.getChanceAsStringValue(stack);
            list.add((Component)ComponentWrapper.string("Chance Value: " + chance));
        }
        if (item.equals(CCubesItems.COMPACT_GIANT_CUBE.get())) {
            list.add((Component)ComponentWrapper.string(String.valueOf(ChatFormatting.RED) + "WARNING: The Giant Chance Cube will probably cause lots damage and/or place a lot of blocks down... You've been warned."));
        } else if (item.equals(CCubesItems.CHANCE_CUBE.get())) {
            list.add((Component)ComponentWrapper.string(String.valueOf(ChatFormatting.RED) + "Warning: It is recommended you don't open these in or next to your base."));
        }
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        int chance;
        boolean placed = super.placeBlock(context, state);
        BlockEntity te = context.getLevel().getBlockEntity(context.getClickedPos());
        if (te != null && (chance = this.getChance(context.getItemInHand())) != -101 && te instanceof TileChanceCube) {
            ((TileChanceCube)te).setChance(chance);
        }
        return placed;
    }
}

