/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.client.gui;

import chanceCubes.client.listeners.RenderEvent;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.SchematicUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SchematicCreationGui
extends Screen {
    private final String[] buttonText = new String[]{"x--", "x++", "y--", "y++", "z--", "z++"};
    private EditBox nameField;
    private final Player player;

    public SchematicCreationGui(Player player) {
        super((Component)ComponentWrapper.string("Test"));
        this.player = player;
    }

    public void init() {
        this.clearWidgets();
        int i = this.width / 2;
        this.nameField = new EditBox(this.font, i - 70, 10, 140, 12, (Component)ComponentWrapper.string("TEST"));
        this.nameField.setTextColor(-1);
        this.nameField.setMaxLength(100);
        this.nameField.setValue("Schematic Name");
        this.addWidget((GuiEventListener)this.nameField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentWrapper.string("Back"), button -> this.onClose()).bounds(i - 50, this.height - 70, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentWrapper.string("Create"), button -> {
            Object fileName = this.nameField.getValue();
            fileName = ((String)fileName).endsWith(".ccs") ? fileName : (String)fileName + ".ccs";
            SchematicUtil.createCustomSchematic(this.player.level(), SchematicUtil.selectionPoints[0], SchematicUtil.selectionPoints[1], (String)fileName);
            RewardsUtil.sendMessageToPlayer(this.player, "Schematic file named " + (String)fileName + " created!");
            RenderEvent.setCreatingSchematic(false);
            SchematicUtil.selectionPoints[0] = null;
            SchematicUtil.selectionPoints[1] = null;
            this.onClose();
        }).bounds(i - 50, this.height - 40, 100, 20).build());
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 6; ++k) {
                int buttonID = j * 2 + k;
                this.addWidget((GuiEventListener)Button.builder((Component)ComponentWrapper.string(this.buttonText[k]), button -> {
                    int idNormalized = buttonID % 6;
                    int point = buttonID / 6;
                    if (idNormalized == 0) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].offset(-1, 0, 0);
                    } else if (idNormalized == 1) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].offset(1, 0, 0);
                    } else if (idNormalized == 2) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].offset(0, -1, 0);
                    } else if (idNormalized == 3) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].offset(0, 1, 0);
                    } else if (idNormalized == 4) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].offset(0, 0, -1);
                    } else if (idNormalized == 5) {
                        SchematicUtil.selectionPoints[point] = SchematicUtil.selectionPoints[point].offset(0, 0, 1);
                    }
                }).bounds(i - 90 + k * 30, 50 * (j + 1), 25, 20).build());
            }
        }
    }

    public boolean charTyped(char p_73869_1_, int p_73869_2_) {
        if (!this.nameField.charTyped(p_73869_1_, p_73869_2_)) {
            return super.charTyped(p_73869_1_, p_73869_2_);
        }
        return false;
    }

    public boolean mouseClicked(double x, double y, int mouseEvent) {
        super.mouseClicked(x, y, mouseEvent);
        return super.mouseClicked(x, y, mouseEvent);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.nameField != null) {
            this.nameField.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        int i = this.width / 2;
        guiGraphics.drawCenteredString(this.font, "Point 1 " + String.valueOf(SchematicUtil.selectionPoints[0]), i, 40, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, "Point 2 " + String.valueOf(SchematicUtil.selectionPoints[1]), i, 90, 0xFFFFFF);
    }
}

