/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.client.gui;

import chanceCubes.client.ClientHelper;
import chanceCubes.components.CCubesDataComponents;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.network.PacketRewardSelector;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RewardSelectorPendantScreen
extends Screen {
    private static final ResourceLocation guiTextures = ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)"textures/gui/container/gui_reward_selector_pendant.png");
    private EditBox rewardField;
    private String rewardName = "";
    private final Player player;
    private final int imageWidth = 176;
    private final int imageHeight = 54;
    private final ItemStack stack;

    public RewardSelectorPendantScreen(Player player, ItemStack stack) {
        super((Component)ComponentWrapper.string(""));
        this.stack = stack;
        this.player = player;
        this.rewardName = (String)stack.getOrDefault(CCubesDataComponents.REWARD, (Object)"");
    }

    public void init() {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.rewardField = new EditBox(this.font, i + 17, j + 10, 143, 12, (Component)ComponentWrapper.string("Test"));
        this.rewardField.setTextColor(-1);
        this.rewardField.setMaxLength(100);
        this.rewardField.setValue(this.rewardName);
        this.addRenderableWidget((GuiEventListener)this.rewardField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentWrapper.string("Set Reward"), p_onPress_1_ -> {
            this.stack.set(CCubesDataComponents.REWARD, (Object)this.rewardName);
            ClientHelper.sendToServer(new PacketRewardSelector(this.rewardField.getValue()));
            this.rewardName = this.rewardField.getValue();
            this.player.closeContainer();
        }).bounds(i + 57, j + 27, 70, 20).build());
    }

    public void onClose() {
        super.onClose();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(guiTextures, (this.width - this.imageWidth) / 2, (this.height - this.imageHeight) / 2, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.rewardField.render(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

