/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.client.voice;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import javax.sound.sampled.AudioFormat;
import mekanism.additions.client.voice.VoiceInput;
import mekanism.additions.client.voice.VoiceOutput;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.common.Mekanism;

public class VoiceClient
extends Thread {
    private final AudioFormat format = new AudioFormat(16000.0f, 16, 1, true, true);
    private VoiceOutput outputThread;
    private VoiceInput inputThread;
    private DataOutputStream output;
    private DataInputStream input;
    private boolean running;
    private Socket socket;
    private final String ip;

    public VoiceClient(String ip) {
        super("VoiceServer Client Thread " + ip);
        this.ip = ip;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        Mekanism.logger.info("VoiceServer: Starting client connection...");
        try {
            this.socket = new Socket(this.ip, MekanismAdditionsConfig.additions.voicePort.get());
            this.running = true;
            this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.output = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.outputThread = new VoiceOutput(this);
            this.outputThread.start();
            this.inputThread = new VoiceInput(this);
            this.inputThread.start();
            Mekanism.logger.info("VoiceServer: Successfully connected to server.");
        }
        catch (ConnectException e) {
            Mekanism.logger.error("VoiceServer: Server's VoiceServer is disabled.");
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while starting client connection.", (Throwable)e);
        }
    }

    public void disconnect() {
        Mekanism.logger.info("VoiceServer: Stopping client connection...");
        try {
            if (this.inputThread != null) {
                this.inputThread.interrupt();
                this.inputThread.close();
            }
            if (this.outputThread != null) {
                this.outputThread.interrupt();
                this.outputThread.close();
            }
            if (this.output != null) {
                this.output.close();
            }
            if (this.input != null) {
                this.input.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            this.interrupt();
            this.running = false;
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while stopping client connection.", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public DataOutputStream getOutputStream() {
        return this.output;
    }

    public DataInputStream getInputStream() {
        return this.input;
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }
}

