/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;

public class GiantBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private final Int2ObjectMap<Material> materials;
    private final int width;
    private final int height;

    public GiantBlockModel(Int2ObjectMap<Material> materials, int width, int height) {
        this.materials = materials;
        this.width = width;
        this.height = height;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, BlockState blockState, BlockPos pos, Direction direction) {
        int x = Math.abs(pos.getX());
        int y = Math.abs(pos.getY());
        int z = Math.abs(pos.getZ());
        return switch (direction.getAxis()) {
            case Direction.Axis.X -> {
                if (direction.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                    z = Math.abs(z - this.width - 1);
                }
                yield List.of(AthenaQuad.withSprite(1 + z % this.width + y % this.height * this.height));
            }
            case Direction.Axis.Z -> {
                if (direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
                    x = Math.abs(x - this.width - 1);
                }
                yield List.of(AthenaQuad.withSprite(1 + x % this.width + y % this.height * this.height));
            }
            default -> {
                if (direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
                    z = Math.abs(z - this.width - 1);
                }
                yield List.of(AthenaQuad.withSprite(1 + x % this.width + z % this.height * this.height));
            }
        };
    }

    @Override
    public Map<Direction, List<AthenaQuad>> getDefaultQuads(Direction direction) {
        HashMap<Direction, List<AthenaQuad>> quads = new HashMap<Direction, List<AthenaQuad>>(Direction.values().length);
        for (Direction dir : Direction.values()) {
            quads.put(dir, List.of(AthenaQuad.withSprite(0)));
        }
        return quads;
    }

    @Override
    public Int2ObjectMap<TextureAtlasSprite> getTextures(Function<Material, TextureAtlasSprite> getter) {
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : this.materials.int2ObjectEntrySet()) {
            textures.put(entry.getIntKey(), (Object)getter.apply((Material)entry.getValue()));
        }
        return textures;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            int width = GsonHelper.getAsInt((JsonObject)json, (String)"width");
            int height = GsonHelper.getAsInt((JsonObject)json, (String)"height");
            Int2ObjectMap<Material> materials = Factory.parseMaterials(GsonHelper.getAsJsonObject((JsonObject)json, (String)"ctm_textures"), width, height);
            return () -> new GiantBlockModel(materials, width, height);
        }

        private static Int2ObjectMap<Material> parseMaterials(JsonObject json, int width, int height) {
            Int2ObjectArrayMap materials = new Int2ObjectArrayMap();
            materials.put(0, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"particle")));
            for (int i = 1; i <= width * height; ++i) {
                Material material = CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)String.valueOf(i)));
                materials.put(i, (Object)material);
            }
            return materials;
        }
    }
}

