/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.IntermittentAnimation;
import com.bobmowzie.mowziesmobs.client.sound.BossMusic;
import com.bobmowzie.mowziesmobs.client.sound.BossMusicPlayer;
import com.bobmowzie.mowziesmobs.server.bossinfo.MMBossInfoServer;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.IntermittentAnimatableEntity;
import com.bobmowzie.mowziesmobs.server.world.spawn.SpawnHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public abstract class MowzieEntity
extends PathfinderMob
implements IEntityWithComplexSpawn,
IntermittentAnimatableEntity {
    private static final byte START_IA_HEALTH_UPDATE_ID = 4;
    private static final byte MUSIC_PLAY_ID = 67;
    private static final byte MUSIC_STOP_ID = 68;
    public int frame;
    public float targetDistance = -1.0f;
    public float targetAngle = -1.0f;
    public boolean active;
    public LivingEntity blockingEntity = null;
    public boolean playsHurtAnimation = true;
    protected boolean dropAfterDeathAnim = true;
    public boolean hurtInterruptsAnimation = false;
    private final List<IntermittentAnimation<?>> intermittentAnimations = new ArrayList();
    public Vec3[] socketPosArray;
    protected boolean prevOnGround;
    protected boolean prevPrevOnGround;
    protected boolean willLandSoon;
    private int killDataRecentlyHit;
    private DamageSource killDataCause;
    private Player killDataAttackingPlayer;
    protected final MMBossInfoServer bossInfo = this.initBossInfo();
    private static final ResourceLocation HEALTH_CONFIG_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"health_config_modifier");
    private static final ResourceLocation ATTACK_CONFIG_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"attack_config_modifier");
    private static final EntityDataAccessor<Boolean> STRAFING = SynchedEntityData.defineId(MowzieEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public boolean renderingInGUI = false;

    public MowzieEntity(EntityType<? extends MowzieEntity> type, Level world) {
        super(type, world);
        ConfigHandler.CombatConfig combatConfig;
        if (world.isClientSide) {
            this.socketPosArray = new Vec3[0];
        }
        if ((combatConfig = this.getCombatConfig()) != null) {
            AttributeInstance attackDamageAttr;
            AttributeInstance maxHealthAttr = this.getAttribute(Attributes.MAX_HEALTH);
            if (maxHealthAttr != null) {
                double difference = maxHealthAttr.getBaseValue() * (Double)this.getCombatConfig().healthMultiplier.get() - maxHealthAttr.getBaseValue();
                maxHealthAttr.addTransientModifier(new AttributeModifier(HEALTH_CONFIG_MODIFIER, difference, AttributeModifier.Operation.ADD_VALUE));
                this.setHealth(this.getMaxHealth());
            }
            if ((attackDamageAttr = this.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
                double difference = attackDamageAttr.getBaseValue() * (Double)this.getCombatConfig().attackMultiplier.get() - attackDamageAttr.getBaseValue();
                attackDamageAttr.addTransientModifier(new AttributeModifier(ATTACK_CONFIG_MODIFIER, difference, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STRAFING, (Object)false);
    }

    public void setStrafing(boolean strafing) {
        this.entityData.set(STRAFING, (Object)strafing);
    }

    public boolean isStrafing() {
        return (Boolean)this.entityData.get(STRAFING);
    }

    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return null;
    }

    protected ConfigHandler.CombatConfig getCombatConfig() {
        return null;
    }

    public static boolean spawnPredicate(EntityType type, LevelAccessor world, MobSpawnType reason, BlockPos spawnPos, RandomSource rand) {
        if (!(world instanceof ServerLevelAccessor)) {
            return false;
        }
        ConfigHandler.SpawnConfig spawnConfig = SpawnHandler.SPAWN_CONFIGS.get(type);
        if (spawnConfig != null) {
            ResourceLocation currDimensionName;
            if (rand.nextDouble() > (Double)spawnConfig.extraRarity.get()) {
                return false;
            }
            List dimensionNames = (List)spawnConfig.dimensions.get();
            if (!dimensionNames.contains((currDimensionName = ((ServerLevel)world).dimension().location()).toString())) {
                return false;
            }
            float heightMax = ((Integer)spawnConfig.heightMax.get()).intValue();
            float heightMin = ((Integer)spawnConfig.heightMin.get()).intValue();
            if ((float)spawnPos.getY() > heightMax && heightMax >= -64.0f) {
                return false;
            }
            if ((float)spawnPos.getY() < heightMin && heightMin >= -64.0f) {
                return false;
            }
            if (((Boolean)spawnConfig.needsDarkness.get()).booleanValue() && !Monster.isDarkEnoughToSpawn((ServerLevelAccessor)((ServerLevelAccessor)world), (BlockPos)spawnPos, (RandomSource)rand)) {
                return false;
            }
            BlockState block = world.getBlockState(spawnPos.below());
            ResourceLocation blockName = block.getBlock().builtInRegistryHolder().key().location();
            List allowedBlocks = (List)spawnConfig.allowedBlocks.get();
            List allowedBlockTags = (List)spawnConfig.allowedBlockTags.get();
            if (blockName == null) {
                return false;
            }
            if (allowedBlocks.isEmpty() && allowedBlockTags.isEmpty()) {
                if (!block.isValidSpawn((BlockGetter)world, spawnPos.below(), type)) {
                    return false;
                }
            } else {
                boolean isBlockAllowed = false;
                if (!allowedBlocks.isEmpty() && (allowedBlocks.contains(blockName.toString()) || allowedBlocks.contains(blockName.getPath()))) {
                    isBlockAllowed = true;
                }
                if (!isBlockAllowed && !allowedBlockTags.isEmpty() && MowzieEntity.isBlockTagAllowed(allowedBlockTags, block)) {
                    isBlockAllowed = true;
                }
                if (!isBlockAllowed) {
                    return false;
                }
            }
            if (((Boolean)spawnConfig.needsSeeSky.get()).booleanValue() && !world.canSeeSkyFromBelowWater(spawnPos)) {
                return false;
            }
            if (((Boolean)spawnConfig.needsCantSeeSky.get()).booleanValue() && world.canSeeSkyFromBelowWater(spawnPos)) {
                return false;
            }
            List avoidStructures = (List)spawnConfig.avoidStructures.get();
            Registry structureSetRegistry = world.registryAccess().registryOrThrow(Registries.STRUCTURE_SET);
            ServerLevel serverLevel = (ServerLevel)world;
            ChunkGeneratorStructureState generatorState = serverLevel.getChunkSource().getGeneratorState();
            ChunkPos chunkPos = new ChunkPos(spawnPos);
            for (String structureName : avoidStructures) {
                Optional holderOptional;
                Optional resourceKeyOptional;
                Optional structureSetOptional = structureSetRegistry.getOptional(ResourceLocation.tryParse((String)structureName));
                if (structureSetOptional.isEmpty() || (resourceKeyOptional = structureSetRegistry.getResourceKey((Object)((StructureSet)structureSetOptional.get()))).isEmpty() || (holderOptional = structureSetRegistry.getHolder((ResourceKey)resourceKeyOptional.get())).isEmpty() || !generatorState.hasStructureChunkInRange((Holder)holderOptional.get(), chunkPos.x, chunkPos.z, 3)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isBlockTagAllowed(List<? extends String> allowedBlockTags, BlockState block) {
        for (String string : allowedBlockTags) {
            TagKey tagKey;
            ResourceLocation location = ResourceLocation.tryParse((String)string);
            if (location == null || !block.is(tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)location))) continue;
            return true;
        }
        return false;
    }

    protected boolean isWithinDistance(BlockPos pos, int distance) {
        return pos.closerThan((Vec3i)this.blockPosition(), (double)distance);
    }

    public void checkDespawn() {
        if (EventHooks.checkMobDespawn((Mob)this)) {
            return;
        }
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
        } else if (!this.isPersistenceRequired() && !this.requiresCustomPersistence()) {
            Player entity = this.level().getNearestPlayer((Entity)this, -1.0);
            if (entity != null) {
                int despawnDistance;
                int despawnRadius;
                double distance = entity.distanceToSqr((Entity)this);
                if (distance > (double)(despawnRadius = (despawnDistance = this.getDespawnDistance()) * despawnDistance) && this.removeWhenFarAway(distance)) {
                    this.discard();
                }
                int noDespawnDistance = this.getNoDespawnDistance();
                int noDespawnRadius = noDespawnDistance * noDespawnDistance;
                if (this.noActionTime > 600 && this.random.nextInt(800) == 0 && distance > (double)noDespawnRadius && this.removeWhenFarAway(distance)) {
                    this.discard();
                } else if (distance < (double)noDespawnRadius) {
                    this.noActionTime = 0;
                }
            }
        } else {
            this.noActionTime = 0;
        }
    }

    public int getDespawnDistance() {
        return this.getType().getCategory().getDespawnDistance();
    }

    public int getNoDespawnDistance() {
        return this.getType().getCategory().getNoDespawnDistance();
    }

    public void tick() {
        this.prevPrevOnGround = this.prevOnGround;
        this.prevOnGround = this.onGround();
        super.tick();
        ++this.frame;
        if (this.tickCount % 4 == 0) {
            this.bossInfo.update();
        }
        if (this.getTarget() != null) {
            this.targetDistance = this.distanceTo((Entity)this.getTarget()) - this.getTarget().getBbWidth() / 2.0f;
            this.targetAngle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)this.getTarget());
        }
        boolean bl = this.willLandSoon = !this.onGround() && this.level().noCollision(this.getBoundingBox().move(this.getDeltaMovement()));
        if (!this.level().isClientSide && this.hasBossMusic()) {
            if (this.canPlayMusic()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)67);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)68);
            }
        }
    }

    protected boolean canPlayMusic() {
        return !this.isSilent() && this.getTarget() instanceof Player;
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.canAttack((LivingEntity)player) && this.distanceTo((Entity)player) < 2500.0f;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
    }

    public void writeSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
    }

    public void readSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
        this.yRotO = this.getYRot();
        this.yBodyRot = this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yHeadRotO;
    }

    public boolean doHurtTarget(Entity entityIn) {
        return this.doHurtTarget(entityIn, 1.0f, 1.0f);
    }

    public boolean doHurtTarget(Entity entityIn, float damageMultiplier, float applyKnockbackMultiplier) {
        return this.doHurtTarget(entityIn, damageMultiplier, applyKnockbackMultiplier, false);
    }

    public boolean doHurtTarget(Entity target, float damageMultiplier, float applyKnockbackMultiplier, boolean canDisableShield) {
        boolean wasHurt;
        float damage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE) * damageMultiplier;
        DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)target, (DamageSource)damagesource, (float)damage);
        }
        if (wasHurt = target.hurt(damagesource, damage)) {
            Level level2;
            LivingEntity livingTarget;
            float knockback;
            if (target instanceof LivingEntity && (knockback = this.getKnockback((Entity)(livingTarget = (LivingEntity)target), damagesource) * applyKnockbackMultiplier) > 0.0f) {
                livingTarget.knockback((double)(knockback * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((level2 = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)target, (DamageSource)damagesource);
            }
            this.setLastHurtMob(target);
            this.playAttackSound();
        }
        return wasHurt;
    }

    public float getHealthRatio() {
        return this.getHealth() / this.getMaxHealth();
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.getZ() - first.getZ(), second.getX() - first.getX()) * 57.29577951308232 + 90.0;
    }

    public double getDotProductBodyFacingEntity(Entity second) {
        Vec3 vecBetween = second.position().subtract(this.position());
        vecBetween = vecBetween.normalize();
        return vecBetween.dot(Vec3.directionFromRotation((float)0.0f, (float)this.yBodyRot).normalize());
    }

    public List<Player> getPlayersNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List nearbyEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(distanceX, distanceY, distanceZ));
        List<Player> listEntityPlayers = nearbyEntities.stream().filter(entityNeighbor -> entityNeighbor instanceof Player && (double)this.distanceTo((Entity)entityNeighbor) <= radius + (double)(entityNeighbor.getBbWidth() / 2.0f)).map(entityNeighbor -> (Player)entityNeighbor).collect(Collectors.toList());
        return listEntityPlayers;
    }

    public List<LivingEntity> getAttackableEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List nearbyEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(distanceX, distanceY, distanceZ));
        List<LivingEntity> listEntityLivingBase = nearbyEntities.stream().filter(entityNeighbor -> entityNeighbor instanceof LivingEntity && ((LivingEntity)entityNeighbor).attackable() && (!(entityNeighbor instanceof Player) || !((Player)entityNeighbor).isCreative()) && (double)this.distanceTo((Entity)entityNeighbor) <= radius + (double)(entityNeighbor.getBbWidth() / 2.0f)).map(entityNeighbor -> (LivingEntity)entityNeighbor).collect(Collectors.toList());
        return listEntityLivingBase;
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double r) {
        return this.level().getEntitiesOfClass(entityClass, this.getBoundingBox().inflate(r, r, r), e -> e != this && (double)this.distanceTo((Entity)e) <= r + (double)(e.getBbWidth() / 2.0f));
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.level().getEntitiesOfClass(entityClass, this.getBoundingBox().inflate(dX, dY, dZ), e -> e != this && (double)this.distanceTo((Entity)e) <= r + (double)(e.getBbWidth() / 2.0f) && e.getY() <= this.getY() + dY);
    }

    protected void tickDeath() {
        Level level;
        ++this.deathTime;
        int deathDuration = this.getDeathDuration();
        if (this.deathTime >= deathDuration && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.lastHurtByPlayer = this.killDataAttackingPlayer;
            this.lastHurtByPlayerTime = this.killDataRecentlyHit;
            if (this.dropAfterDeathAnim && this.killDataCause != null) {
                this.dropAllDeathLoot(serverLevel, this.killDataCause);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected abstract int getDeathDuration();

    protected void dropAllDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource source) {
        if (!this.dropAfterDeathAnim || this.deathTime > 0) {
            super.dropAllDeathLoot(level, source);
        }
    }

    public void die(DamageSource cause) {
        if (!this.dead) {
            this.killDataCause = cause;
            this.killDataRecentlyHit = this.lastHurtByPlayerTime;
            this.killDataAttackingPlayer = this.lastHurtByPlayer;
        }
        super.die(cause);
        if (!this.isRemoved()) {
            this.bossInfo.update();
        }
    }

    protected void addIntermittentAnimation(IntermittentAnimation animation) {
        animation.setID((byte)this.intermittentAnimations.size());
        this.intermittentAnimations.add(animation);
    }

    public void handleEntityEvent(byte id) {
        if (id >= 4 && id - 4 < this.intermittentAnimations.size()) {
            this.intermittentAnimations.get(id - 4).start();
        } else if (id == 67) {
            BossMusicPlayer.requestBossMusic(this);
        } else if (id == 68) {
            BossMusicPlayer.stopBossMusic(this);
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Override
    public byte getOffsetEntityState() {
        return 4;
    }

    public Vec3 circleEntityPosition(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset) {
        int directionInt = direction ? 1 : -1;
        double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        Vec3 movePos = target.position().add((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
        return movePos;
    }

    protected void repelEntities(float x, float y, float z, float radius) {
        List<LivingEntity> nearbyEntities = this.getEntityLivingBaseNearby(x, y, z, radius);
        for (Entity entity : nearbyEntities) {
            if (!entity.isPickable() || entity.noPhysics) continue;
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.setDeltaMovement(-0.1 * Math.cos(angle), entity.getDeltaMovement().y, -0.1 * Math.sin(angle));
        }
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    public void setCustomName(Component name) {
        super.setCustomName(name);
        this.bossInfo.setName(this.getDisplayName());
    }

    public boolean hasBossBar() {
        return false;
    }

    protected MMBossInfoServer initBossInfo() {
        return new MMBossInfoServer(this);
    }

    public boolean resetHealthOnPlayerRespawn() {
        return false;
    }

    public BossEvent.BossBarColor bossBarColor() {
        return BossEvent.BossBarColor.PURPLE;
    }

    public void setSocketPosArray(int index, Vec3 pos) {
        if (this.socketPosArray != null && this.socketPosArray.length > index) {
            this.socketPosArray[index] = pos;
        }
    }

    public boolean canBePushedByEntity(Entity entity) {
        return true;
    }

    public void push(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!(this.isSleeping() || this.isPassengerOfSameVehicle(entityIn) || entityIn.noPhysics || this.noPhysics || !((d2 = Mth.absMax((double)(d0 = entityIn.getX() - this.getX()), (double)(d1 = entityIn.getZ() - this.getZ()))) >= (double)0.01f))) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.isVehicle() && this.canBePushedByEntity(entityIn)) {
                this.push(-d0, 0.0, -d1);
            }
            if (!entityIn.isVehicle()) {
                entityIn.push(d0, 0.0, d1);
            }
        }
    }

    public boolean hasBossMusic() {
        return false;
    }

    public BossMusic<?> getBossMusic() {
        return null;
    }
}

