/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.block;

import com.bobmowzie.mowziesmobs.server.block.GongBlock;
import com.bobmowzie.mowziesmobs.server.block.RakedSandBlock;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class BlockHandler {
    public static final DeferredRegister<Block> REG = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"mowziesmobs");
    public static final DeferredHolder<Block, Block> PAINTED_ACACIA = BlockHandler.registerBlockAndItem("painted_acacia", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_PLANKS).strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final DeferredHolder<Block, Block> PAINTED_ACACIA_SLAB = BlockHandler.registerBlockAndItem("painted_acacia_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)PAINTED_ACACIA.get()))));
    public static final DeferredHolder<Block, Block> THATCH = BlockHandler.registerBlockAndItem("thatch_block", () -> new HayBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK)));
    public static final DeferredHolder<Block, Block> GONG = BlockHandler.registerBlockAndItem("gong", () -> new GongBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_BLOCK).requiresCorrectToolForDrops().strength(5.0f).sound(SoundType.ANVIL)));
    public static final DeferredHolder<Block, Block> GONG_PART = REG.register("gong_part", () -> new GongBlock.GongPartBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_BLOCK).requiresCorrectToolForDrops().strength(5.0f).sound(SoundType.ANVIL)));
    public static final DeferredHolder<Block, Block> RAKED_SAND = BlockHandler.registerBlockAndItem("raked_sand", () -> new RakedSandBlock(new ColorRGBA(14406560), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND), Blocks.SAND.defaultBlockState()));
    public static final DeferredHolder<Block, Block> RED_RAKED_SAND = BlockHandler.registerBlockAndItem("red_raked_sand", () -> new RakedSandBlock(new ColorRGBA(11098145), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_SAND), Blocks.RED_SAND.defaultBlockState()));
    public static final DeferredHolder<Block, Block> CLAWED_LOG = BlockHandler.registerBlockAndItem("clawed_log", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_PLANKS)));

    public static DeferredHolder<Block, Block> registerBlockAndItem(String name, Supplier<Block> block) {
        DeferredHolder blockObj = REG.register(name, block);
        ItemHandler.REG.register(name, () -> new BlockItem((Block)blockObj.get(), new Item.Properties()));
        return blockObj;
    }

    public static void init() {
        FireBlock fireblock = (FireBlock)Blocks.FIRE;
        fireblock.setFlammable((Block)THATCH.get(), 60, 20);
        fireblock.setFlammable((Block)PAINTED_ACACIA.get(), 5, 20);
        fireblock.setFlammable((Block)PAINTED_ACACIA_SLAB.get(), 5, 20);
        fireblock.setFlammable((Block)CLAWED_LOG.get(), 5, 5);
    }
}

