/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.mana.ActiveCircleConfig;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.MahoujinTickingTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.Utils;

public class ChronalExchangeMahoujinTileEntity
extends MahoujinTickingTileEntity {
    private long dayCounter = 0L;
    private static final String DAY_COUNTER_TAG = "MAHOUTSUKAI_DAY_COUNTER_TAG";

    public ChronalExchangeMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.chronalExchange.get(), p, bs);
    }

    @Override
    public void tick(Level level, BlockPos blockPos, BlockState blockState, MahoujinTickingTileEntity blockEntity) {
        super.tick(level, blockPos, blockState, blockEntity);
        if (!level.isClientSide) {
            ++this.dayCounter;
            this.dayCounter %= 24000L;
            if (this.dayCounter < 0L) {
                this.dayCounter += 24000L;
            }
        }
    }

    @Override
    public int blockCycle() {
        return MTConfig.CHRONAL_EXCHANGE_BLOCK_CYCLE;
    }

    @Override
    public void mahoujinTick(Level level, BlockPos blockPos, BlockState blockState, MahoujinTickingTileEntity blockEntity) {
        if (ActiveCircleConfig.tryToOperate(this, this.getCasterUUID())) {
            this.doManaGenOrLoss();
        }
    }

    public void setTime(long t) {
        this.dayCounter = t;
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putLong(DAY_COUNTER_TAG, this.dayCounter);
        super.saveAdditional(compound, provider);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.dayCounter = compound.getLong(DAY_COUNTER_TAG);
        super.loadAdditional(compound, provider);
    }

    public void doManaGenOrLoss() {
        IMahou mahou;
        Player player = this.getCaster();
        if (player != null && this.level != null && (mahou = Utils.getPlayerMahou(player)) != null) {
            int restore = this.calculateMana();
            if (restore < 0) {
                PlayerManaManager.drainMana(player, -restore, false, false, false, true);
            } else {
                int storedMana = mahou.getStoredMana();
                mahou.setStoredMana(Math.min(storedMana + restore, mahou.getMaxMana()));
            }
        }
    }

    public int calculateMana() {
        return this.getManaFromTime(this.level.getDayTime());
    }

    public int getManaFromTime(long t) {
        float distance;
        float smaller = -MTConfig.CHRONAL_EXCHANGE_MANA_GAIN_LOSS;
        float diff = 2 * MTConfig.CHRONAL_EXCHANGE_MANA_GAIN_LOSS;
        long now = t % 24000L;
        if (now < 0L) {
            now += 24000L;
        }
        if ((distance = (float)(this.dayCounter % 24000L)) < 0.0f) {
            distance += 24000.0f;
        }
        float ratio = Math.abs(distance - 12000.0f) / 12000.0f;
        int ret = (int)(smaller + diff * ratio);
        return ret;
    }

    public boolean timeInRange(long x, long y) {
        return x < y + 6000L && x >= y - 6000L;
    }
}

