/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.dataattachments.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.render.gui.ButtonList;
import stepsword.mahoutsukai.render.gui.SpellSettingGUI;

public class PlayerSettingsGUI
extends Screen {
    Level world;
    UUID uuid;
    ButtonList buttons;

    public PlayerSettingsGUI(Level w, UUID u) {
        super((Component)Component.translatable((String)"mahoutsukai.settings.screen"));
        this.world = w;
        this.uuid = u;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    protected void init() {
        int top = 30;
        int buttonheight = 24;
        this.buttons = new ButtonList(Minecraft.getInstance(), this.width, this.height, top, buttonheight, buttonheight);
        boolean n = false;
        this.addColorSettingButton("mahoutsukai.settings.rho_aias", MahouSettings.Spell.RHO_AIAS);
        this.addColorSettingButton("mahoutsukai.settings.gandr", MahouSettings.Spell.GANDR);
        this.addColorSettingButton("mahoutsukai.settings.treasury_weapons", MahouSettings.Spell.TREASURY_WEAPONS);
        this.addColorSettingButton("mahoutsukai.settings.treasury_chains", MahouSettings.Spell.TREASURY_CHAINS);
        this.addColorSettingButton("mahoutsukai.settings.morgan", MahouSettings.Spell.MORGAN);
        this.addColorSettingButton("mahoutsukai.settings.morgan_ball", MahouSettings.Spell.MORGAN_BALL);
        this.addColorSettingButton("mahoutsukai.settings.mystic_staff_big", MahouSettings.Spell.MYSTIC_STAFF_BIG);
        this.addColorSettingButton("mahoutsukai.settings.mystic_staff_aoe", MahouSettings.Spell.MYSTIC_STAFF_AOE);
        this.addColorSettingButton("mahoutsukai.settings.mystic_staff_beam", MahouSettings.Spell.MYSTIC_STAFF_BEAM);
        this.addColorSettingButton("mahoutsukai.settings.weapon_projectile", MahouSettings.Spell.WEAPON_PROJECTILE);
        this.addColorSettingButton("mahoutsukai.settings.nobu", MahouSettings.Spell.NOBU);
        this.addColorSettingButton("mahoutsukai.settings.william_book", MahouSettings.Spell.WILLIAM_BOOK);
        this.addColorSettingButton("mahoutsukai.settings.william_magic", MahouSettings.Spell.WILLIAM_MAGIC);
        this.addColorSettingButton("mahoutsukai.settings.rlyeh_book", MahouSettings.Spell.RLYEH_BOOK);
        this.addColorSettingButton("mahoutsukai.settings.rlyeh_magic", MahouSettings.Spell.RLYEH_MAGIC);
        this.renderables.add(this.buttons);
        super.init();
    }

    public void addColorSettingButton(String s, MahouSettings.Spell spell) {
        SpellSettingGUI gui = new SpellSettingGUI((Component)Component.translatable((String)s), this.font, spell);
        if (MahouSettings.primaryColor.contains((Object)spell)) {
            gui = gui.createPrimaryColorSetting();
        }
        if (MahouSettings.secondaryColor.contains((Object)spell)) {
            gui = gui.createSecondaryColorSetting();
        }
        this.addButton(s, 24, gui);
    }

    public void addButton(String translation, int h, final SpellSettingGUI gui) {
        ButtonList buttonList = this.buttons;
        Objects.requireNonNull(buttonList);
        this.buttons.addEntry(new ButtonList.ButtonListEntry(buttonList, new Button.Builder((Component)Component.translatable((String)translation), new Button.OnPress(){

            public void onPress(Button button) {
                Minecraft.getInstance().setScreen((Screen)gui);
            }
        }).pos(0, 0).size(60, h).build()));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.buttons.mouseClicked(mouseX, mouseY, button);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.buttons.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.buttons.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }
}

