/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.entity.GateChainEntity;
import stepsword.mahoutsukai.entity.LightningEntity;
import stepsword.mahoutsukai.entity.MorganBallEntity;
import stepsword.mahoutsukai.entity.SmiteEntity;
import stepsword.mahoutsukai.entity.WilliamEntity;
import stepsword.mahoutsukai.entity.fae.FaeEntity;
import stepsword.mahoutsukai.entity.mahoujin.AuthorityMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.BeamProjectileEntity;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownBeamEntity;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownEntity;
import stepsword.mahoutsukai.entity.mahoujin.GandrEntity;
import stepsword.mahoutsukai.entity.mahoujin.GunBeamProjectileEntity;
import stepsword.mahoutsukai.entity.mahoujin.GunEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffAOEMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.ReplicaTeleportMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.RhoAiasMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.RhongomyniadEntity;
import stepsword.mahoutsukai.entity.mahoujin.SpatialDisorientationMahoujinEntity;
import stepsword.mahoutsukai.integration.ShaderIntegration;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.proxy.ClientProxy;
import stepsword.mahoutsukai.render.ClippedRenderTypeBuffer;
import stepsword.mahoutsukai.render.IEntityAwareRenderer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.entity.RenderAOEMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderAuthorityMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderBeamProjectileEntity;
import stepsword.mahoutsukai.render.entity.RenderFaeEntity;
import stepsword.mahoutsukai.render.entity.RenderFallenDownBeamEntity;
import stepsword.mahoutsukai.render.entity.RenderFallenDownEntity;
import stepsword.mahoutsukai.render.entity.RenderGandrEntity;
import stepsword.mahoutsukai.render.entity.RenderGateChainEntity;
import stepsword.mahoutsukai.render.entity.RenderGunBeamProjectile;
import stepsword.mahoutsukai.render.entity.RenderGunEntity;
import stepsword.mahoutsukai.render.entity.RenderLightningEntity;
import stepsword.mahoutsukai.render.entity.RenderMorganBallEntity;
import stepsword.mahoutsukai.render.entity.RenderMysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderMysticStaffMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderReplicaTeleportEntity;
import stepsword.mahoutsukai.render.entity.RenderRhoAiasMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderRhongomyniadEntity;
import stepsword.mahoutsukai.render.entity.RenderSmiteEntity;
import stepsword.mahoutsukai.render.entity.RenderSpatialDisorientationMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderWilliamEntity;
import stepsword.mahoutsukai.render.particle.ParticleFog;
import stepsword.mahoutsukai.render.particle.ParticleLightning;
import stepsword.mahoutsukai.render.particle.ParticleMagic;
import stepsword.mahoutsukai.render.particle.ParticleSmokeRing;
import stepsword.mahoutsukai.render.particle.ParticleSphere;
import stepsword.mahoutsukai.render.particle.ParticleSphereExplosion;
import stepsword.mahoutsukai.render.shader.FogShaderInstance;
import stepsword.mahoutsukai.render.shader.ModShaders;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RenderUtils {
    public static final ResourceLocation mahoujin = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/mahoujin_casting.png");
    public static final ResourceLocation runes = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/runes.png");
    public static final ResourceLocation beam = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/white.png");
    public static final ResourceLocation black = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/black.png");
    public static ModelResourceLocation TRIDENT_MODEL = ModelResourceLocation.vanilla((String)"trident", (String)"inventory");

    public static Quaternionf getQuaternion(float x, float y, float z, float w, boolean b) {
        if (b) {
            w *= (float)Math.PI / 180;
        }
        float f = org.joml.Math.sin((float)(w / 2.0f));
        float i = x * f;
        float j = y * f;
        float k = z * f;
        float r = org.joml.Math.cos((float)(w / 2.0f));
        return new Quaternionf(i, j, k, r);
    }

    public static Quaternionf getQuaternion(Vector3f v, float w, boolean b) {
        return RenderUtils.getQuaternion(v.x, v.y, v.z, w, b);
    }

    public static void rotateQ(float w, float x, float y, float z, PoseStack matrix) {
        matrix.mulPose(RenderUtils.getQuaternion(x, y, z, w, true));
    }

    public static RenderType renderRingCull(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, int ring_index) {
        RenderType type = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createRunesRenderType(runes, ring_index));
        return RenderUtils.renderRing(matrix, buffer, cy, flatness, radius, height, num_segments, lx, ly, r, g, b, a, type);
    }

    public static RenderType renderRing(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, int ring_index, ItemDisplayContext transform) {
        RenderType type = ShaderIntegration.shaderify((RenderType.CompositeRenderType)MahoujinRenderType.createRunesRenderType(runes, 0), transform);
        return RenderUtils.renderRing(matrix, buffer, cy, flatness, radius, height, num_segments, lx, ly, r, g, b, a, type);
    }

    public static RenderType renderSphere(PoseStack matrix, MultiBufferSource buf, float radius, int gradation, int lx, int ly, float r, float g, float b, float a, ItemDisplayContext transform) {
        RenderType type = MahoujinRenderType.wrapCullLayer(ShaderIntegration.shaderify((RenderType.CompositeRenderType)MahoujinRenderType.createSphereRenderType(beam, 0), transform));
        RenderUtils.renderSphere(matrix, buf, radius, gradation, lx, ly, r, g, b, a, type);
        return type;
    }

    public static RenderType renderRing(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, int ring_index) {
        RenderType type = MahoujinRenderType.createRunesRenderType(runes, 0);
        return RenderUtils.renderRing(matrix, buffer, cy, flatness, radius, height, num_segments, lx, ly, r, g, b, a, type);
    }

    public static RenderType renderRing(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, int ring_index, ResourceLocation loc) {
        RenderType type = MahoujinRenderType.createRunesRenderType(loc, 0);
        return RenderUtils.renderRing(matrix, buffer, cy, flatness, radius, height, num_segments, lx, ly, r, g, b, a, type);
    }

    public static RenderType renderSphere(PoseStack matrix, MultiBufferSource buf, float radius, int gradation, int lx, int ly, float r, float g, float b, float a) {
        RenderType type = MahoujinRenderType.createSphereRenderType(beam, 0);
        RenderUtils.renderSphere(matrix, buf, radius, gradation, lx, ly, r, g, b, a, type);
        return type;
    }

    public static RenderType renderRing(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type) {
        matrix.pushPose();
        Matrix4f positionMatrix = matrix.last().pose();
        VertexConsumer bb = buffer.getBuffer(type);
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float squeeze = 3.0f;
        float texx = 0.0f;
        for (int i = 0; i < num_segments + 1; ++i) {
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                bb.addVertex(positionMatrix, (float)x, (float)y, (float)z).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lx, ly);
                bb.addVertex(positionMatrix, (float)xb, (float)yb, (float)zb).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lx, ly);
            }
            double tt = (double)i * theta;
            x = (double)(-radius) * Math.sin(tt);
            y = cy;
            z = (double)radius * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = cy - q;
            zb = p * Math.cos(tt);
            bb.addVertex(positionMatrix, (float)x, (float)y, (float)z).setColor(r, g, b, a).setUv(texx, 0.0f).setUv2(lx, ly);
            bb.addVertex(positionMatrix, (float)xb, (float)yb, (float)zb).setColor(r, g, b, a).setUv(texx, 1.0f).setUv2(lx, ly);
        }
        matrix.popPose();
        return type;
    }

    public static void translateBasic(double x, double y, double z, PoseStack matrix) {
        Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 basic = renderInfo.getPosition();
        RenderUtils.rotateQ(renderInfo.getXRot(), 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(renderInfo.getYRot() + 180.0f, 0.0f, 1.0f, 0.0f, matrix);
        matrix.translate(x - basic.x, y - basic.y, z - basic.z);
    }

    public static void bindTexture(ResourceLocation r) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)r);
    }

    public static void renderClippedItem(ItemStack itemStackIn, ItemDisplayContext transformTypeIn, boolean leftHand, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BakedModel modelIn, float progress, double x, double y, double z, double yaw, double pitch, double size, boolean clip) {
        if (!itemStackIn.isEmpty()) {
            boolean flag;
            matrixStackIn.pushPose();
            Matrix4f m = new Matrix4f((Matrix4fc)matrixStackIn.last().pose());
            boolean bl = flag = transformTypeIn == ItemDisplayContext.GUI || transformTypeIn == ItemDisplayContext.GROUND || transformTypeIn == ItemDisplayContext.FIXED;
            if (itemStackIn.getItem() == Items.TRIDENT && flag) {
                modelIn = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getModelManager().getModel(TRIDENT_MODEL);
            }
            if (!(modelIn = ClientHooks.handleCameraTransforms((PoseStack)matrixStackIn, (BakedModel)modelIn, (ItemDisplayContext)transformTypeIn, (boolean)leftHand)).isCustomRenderer() && (itemStackIn.getItem() != Items.TRIDENT || flag)) {
                Block block;
                boolean flag1 = transformTypeIn != ItemDisplayContext.GUI && !transformTypeIn.firstPerson() && itemStackIn.getItem() instanceof BlockItem ? !((block = ((BlockItem)itemStackIn.getItem()).getBlock()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                RenderType rendertype = ItemBlockRenderTypes.getRenderType((ItemStack)itemStackIn, (boolean)flag1);
                RenderType rendertype1 = flag && Objects.equals(rendertype, Sheets.translucentItemSheet()) ? Sheets.translucentCullBlockSheet() : rendertype;
                rendertype1 = MahoujinRenderType.wrapClipLayer(rendertype1, clip, pitch, yaw, x, y, z, progress, size, m);
                VertexConsumer ivertexbuilder = bufferIn.getBuffer(rendertype1);
                RenderUtils.renderModel(modelIn, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder);
            } else {
                ItemStack stack2 = itemStackIn.copy();
                EnchantmentHelper.setEnchantments((ItemStack)stack2, (ItemEnchantments)ItemEnchantments.EMPTY);
                IClientItemExtensions.of((ItemStack)stack2).getCustomRenderer().renderByItem(stack2, transformTypeIn, matrixStackIn, (MultiBufferSource)new ClippedRenderTypeBuffer(bufferIn, clip, pitch, yaw, x, y, z, progress, size, m), combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.popPose();
        }
    }

    private static void renderModel(BakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, PoseStack matrixStackIn, VertexConsumer bufferIn) {
        RandomSource random = RandomSource.create((long)42L);
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            Minecraft.getInstance().getItemRenderer().renderQuadList(matrixStackIn, bufferIn, modelIn.getQuads((BlockState)null, direction, random), stack, combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        Minecraft.getInstance().getItemRenderer().renderQuadList(matrixStackIn, bufferIn, modelIn.getQuads((BlockState)null, (Direction)null, random), stack, combinedLightIn, combinedOverlayIn);
    }

    public static VertexConsumer getBuffer(MultiBufferSource bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean glintIn) {
        return glintIn ? VertexMultiConsumer.create((VertexConsumer)bufferIn.getBuffer(isItemIn ? RenderType.glint() : RenderType.entityGlint()), (VertexConsumer)bufferIn.getBuffer(renderTypeIn)) : bufferIn.getBuffer(renderTypeIn);
    }

    public static void renderFSQ(PoseStack stack, ResourceLocation texture, float r1, float g1, float b1, float a1, float xoffset, float yoffset, float x, float y, float z) {
        float r = r1 / 255.0f;
        float g = g1 / 255.0f;
        float b = b1 / 255.0f;
        float a = a1;
        Matrix4f m = stack.last().pose();
        Entity e = Minecraft.getInstance().getCameraEntity();
        if (e != null) {
            int j = 240;
            int k = 240;
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            RenderType type = MahoujinRenderType.createMahoujinRenderType(texture, 0, false, () -> ModShaders.PASSTHROUGH_QUADS);
            VertexConsumer bb = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(type);
            RenderSystem.enableDepthTest();
            bb.addVertex(m, 0.0f + xoffset, 0.0f + yoffset, z).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(j, k);
            bb.addVertex(m, 0.0f + xoffset, y + yoffset, z).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(j, k);
            bb.addVertex(m, x + xoffset, y + yoffset, z).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(j, k);
            bb.addVertex(m, x + xoffset, 0.0f + yoffset, z).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(j, k);
            buffer.endBatch(type);
        }
    }

    public static void renderTextureOverlay(PoseStack matrix, String loc, int r, int g, int b, float a, float xoffset, float yoffset, float x, float y, float z) {
        ResourceLocation rl = ResourceLocation.parse((String)loc);
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)a);
        RenderUtils.renderFSQ(matrix, rl, r, g, b, a, xoffset, yoffset, x, y, z);
    }

    public static float calculateOverlayFade(int duration, int interval, int fadeTicks, float maxAlpha) {
        int large = duration % interval;
        float alpha = 0.0f;
        if (large > interval - fadeTicks) {
            alpha = ((float)large - ((float)interval - (float)fadeTicks)) / (float)fadeTicks;
            alpha *= maxAlpha;
        }
        return alpha;
    }

    public static void renderSphere(PoseStack matrix, MultiBufferSource buf, float radius, int gradation, int lx, int ly, float r, float g, float b, float a, RenderType type, float percentage) {
        float PI = 3.141592f;
        VertexConsumer bb = buf.getBuffer(type);
        Matrix4f m = matrix.last().pose();
        for (float alpha = 0.0f; alpha < 3.141592f; alpha += 3.141592f / (float)gradation) {
            float beta = 0.0f;
            while ((double)beta < 6.31459997177124 * (double)percentage) {
                float x = (float)((double)radius * Math.cos(beta) * Math.sin(alpha));
                float y = (float)((double)radius * Math.sin(beta) * Math.sin(alpha));
                float z = (float)((double)radius * Math.cos(alpha));
                bb.addVertex(m, x, y, z).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lx, ly);
                x = (float)((double)radius * Math.cos(beta) * Math.sin(alpha + 3.141592f / (float)gradation));
                y = (float)((double)radius * Math.sin(beta) * Math.sin(alpha + 3.141592f / (float)gradation));
                z = (float)((double)radius * Math.cos(alpha + 3.141592f / (float)gradation));
                bb.addVertex(m, x, y, z).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lx, ly);
                beta += 3.141592f / (float)gradation;
            }
        }
    }

    public static void renderSphere(PoseStack matrix, MultiBufferSource buf, float radius, int gradation, int lx, int ly, float r, float g, float b, float a, RenderType type) {
        RenderUtils.renderSphere(matrix, buf, radius, gradation, lx, ly, r, g, b, a, type, 1.0f);
    }

    public static void entityRenders(Entity re, PoseStack matrix, float partialTicks) {
        boolean hasEyes = false;
        if (re instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)re, ModEffects.FAY_SIGHT_EYES)) {
            hasEyes = true;
        }
        Vec3 proj = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        double d3 = proj.x;
        double d4 = proj.y;
        double d5 = proj.z;
        HashSet<Entity> entities = ClientProxy.getAllEntities(Minecraft.getInstance().level);
        if (entities != null && entities.size() > 0) {
            for (Entity entity : entities) {
                double d2;
                double d1;
                double d0;
                if (entity instanceof FaeEntity && entity.distanceToSqr(re) < 3600.0 && (hasEyes || EffectUtil.hasBuff((LivingEntity)((FaeEntity)entity), ModEffects.REVERTED))) {
                    double d02 = entity.xOld + (entity.getX() - entity.xOld) * (double)partialTicks;
                    double d12 = entity.yOld + (entity.getY() - entity.yOld) * (double)partialTicks;
                    double d22 = entity.zOld + (entity.getZ() - entity.zOld) * (double)partialTicks;
                    matrix.pushPose();
                    RenderFaeEntity.render((FaeEntity)entity, d02 - d3, d12 - d4, d22 - d5, matrix, partialTicks);
                    matrix.popPose();
                }
                if (entity instanceof MysticStaffMahoujinEntity && entity.distanceToSqr(re) < 16384.0) {
                    MysticStaffMahoujinEntity beam = (MysticStaffMahoujinEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderMysticStaffMahoujinEntity.renderCircle((MysticStaffMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof MysticStaffBeamMahoujinEntity && entity.distanceToSqr(re) < 16384.0) {
                    MysticStaffBeamMahoujinEntity beam = (MysticStaffBeamMahoujinEntity)entity;
                    d0 = beam.prevx + (beam.getX() - beam.prevx) * (double)partialTicks;
                    d1 = beam.prevy + (beam.getY() - beam.prevy) * (double)partialTicks;
                    d2 = beam.prevz + (beam.getZ() - beam.prevz) * (double)partialTicks;
                    RenderMysticStaffBeamMahoujinEntity.renderBeam((MysticStaffBeamMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof GateChainEntity && entity.distanceToSqr(re) < 4096.0) {
                    GateChainEntity chain = (GateChainEntity)entity;
                    d0 = chain.xo + (chain.getX() - chain.xo) * (double)partialTicks;
                    d1 = chain.yo + (chain.getY() - chain.yo) * (double)partialTicks;
                    d2 = chain.zo + (chain.getZ() - chain.zo) * (double)partialTicks;
                    RenderGateChainEntity.renderCircle((GateChainEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof SmiteEntity && entity.distanceToSqr(re) < 16384.0) {
                    SmiteEntity beam = (SmiteEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderSmiteEntity.renderSmite((SmiteEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof MorganBallEntity && entity.distanceToSqr(re) < 16384.0) {
                    MorganBallEntity beam = (MorganBallEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderMorganBallEntity.renderMorganBall((MorganBallEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof AuthorityMahoujinEntity && entity.distanceToSqr(re) < 16384.0) {
                    AuthorityMahoujinEntity beam = (AuthorityMahoujinEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderAuthorityMahoujinEntity.renderAuthority((AuthorityMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof RhoAiasMahoujinEntity && entity.distanceToSqr(re) < 16384.0) {
                    RhoAiasMahoujinEntity beam = (RhoAiasMahoujinEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderRhoAiasMahoujinEntity.renderRhoAias((RhoAiasMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof ReplicaTeleportMahoujinEntity && entity.distanceToSqr(re) < 16384.0) {
                    ReplicaTeleportMahoujinEntity beam = (ReplicaTeleportMahoujinEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderReplicaTeleportEntity.renderReplica((ReplicaTeleportMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof GandrEntity && entity.distanceToSqr(re) < 4096.0) {
                    GandrEntity beam = (GandrEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderGandrEntity.renderGandr((GandrEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof FallenDownEntity && entity.distanceToSqr(re) < 16384.0) {
                    FallenDownEntity beam = (FallenDownEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderFallenDownEntity.renderFallenDown((FallenDownEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof FallenDownBeamEntity && entity.distanceToSqr(re) < 16384.0) {
                    FallenDownBeamEntity beam = (FallenDownBeamEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderFallenDownBeamEntity.renderFallenDownBeam((FallenDownBeamEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof LightningEntity && entity.distanceToSqr(re) < 16384.0) {
                    LightningEntity beam = (LightningEntity)entity;
                    d0 = beam.prev_x + (beam.getX() - beam.prev_x) * (double)partialTicks;
                    d1 = beam.prev_y + (beam.getY() - beam.prev_y) * (double)partialTicks;
                    d2 = beam.prev_z + (beam.getZ() - beam.prev_z) * (double)partialTicks;
                    RenderLightningEntity.renderLightning((LightningEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof SpatialDisorientationMahoujinEntity && entity.distanceToSqr(re) < 16384.0) {
                    SpatialDisorientationMahoujinEntity beam = (SpatialDisorientationMahoujinEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderSpatialDisorientationMahoujinEntity.renderSpatial((SpatialDisorientationMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof BeamProjectileEntity && entity.distanceToSqr(re) < 16384.0) {
                    BeamProjectileEntity beam = (BeamProjectileEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderBeamProjectileEntity.renderBeamProjectile((BeamProjectileEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof MysticStaffAOEMahoujinEntity && entity.distanceToSqr(re) < 16384.0) {
                    MysticStaffAOEMahoujinEntity beam = (MysticStaffAOEMahoujinEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderAOEMahoujinEntity.renderAOECircle((MysticStaffAOEMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof RhongomyniadEntity && entity.distanceToSqr(re) < 16384.0) {
                    RhongomyniadEntity beam = (RhongomyniadEntity)entity;
                    d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                    d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                    d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                    RenderRhongomyniadEntity.renderRhongomyniad((RhongomyniadEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof GunEntity) {
                    GunEntity beam = (GunEntity)entity;
                    if (entity.distanceToSqr(re) < 16384.0) {
                        d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                        d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                        d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                        RenderGunEntity.renderGun(beam, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                    }
                }
                if (entity instanceof GunBeamProjectileEntity) {
                    GunBeamProjectileEntity beam = (GunBeamProjectileEntity)entity;
                    if (entity.distanceToSqr(re) < 16384.0) {
                        d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                        d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                        d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                        RenderGunBeamProjectile.renderGunBeam(beam, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                    }
                }
                if (!(entity instanceof WilliamEntity)) continue;
                WilliamEntity w = (WilliamEntity)entity;
                if (!(entity.distanceToSqr(re) < 16384.0)) continue;
                d0 = w.xo + (w.getX() - w.xo) * (double)partialTicks;
                d1 = w.yo + (w.getY() - w.yo) * (double)partialTicks;
                d2 = w.zo + (w.getZ() - w.zo) * (double)partialTicks;
                float m = Utils.yawPartial(w.yRotO, w.yRot, partialTicks);
                RenderWilliamEntity.renderWilliam(w, d0 - d3, d1 - d4, d2 - d5, m, matrix, partialTicks);
            }
        }
    }

    public static void particleRenders(Entity re, PoseStack matrix, float partialTicks) {
        Vec3 proj = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        double d3 = proj.x;
        double d4 = proj.y;
        double d5 = proj.z;
        HashSet<Particle> particles = ClientProxy.getNoRenderParticles(Minecraft.getInstance().particleEngine);
        ArrayList<Particle> orderedFog = new ArrayList<Particle>();
        FogShaderInstance.doDepth = true;
        if (particles != null && particles.size() > 0) {
            for (Particle particle : particles) {
                if (!(particle instanceof ParticleSmokeRing)) continue;
                ParticleSmokeRing p3 = (ParticleSmokeRing)particle;
                ParticleSmokeRing.renderSmokeRing(p3, d3, d4, d5, matrix, partialTicks);
            }
            for (Particle particle : particles) {
                Particle p3;
                if (particle instanceof ParticleLightning) {
                    p3 = (ParticleLightning)particle;
                    ParticleLightning.renderLightningParticle((ParticleLightning)p3, d3, d4, d5, matrix, partialTicks);
                }
                if (particle instanceof ParticleFog) {
                    p3 = (ParticleFog)particle;
                    orderedFog.add(p3);
                }
                if (particle instanceof ParticleMagic) {
                    p3 = (ParticleMagic)particle;
                    ParticleMagic.renderMagic((ParticleMagic)p3, d3, d4, d5, matrix, partialTicks);
                }
                if (particle instanceof ParticleSphere) {
                    p3 = (ParticleSphere)particle;
                    ParticleSphere.renderParticleSphere((ParticleSphere)p3, d3, d4, d5, matrix, partialTicks);
                }
                if (!(particle instanceof ParticleSphereExplosion)) continue;
                p3 = (ParticleSphereExplosion)particle;
                ParticleSphereExplosion.renderParticleSphereExplosion((ParticleSphereExplosion)p3, d3, d4, d5, matrix, partialTicks);
            }
        }
        orderedFog.sort((p2, p) -> (int)(10000.0 * (p.getPos().subtract(Minecraft.getInstance().player.position()).length() - p2.getPos().subtract(Minecraft.getInstance().player.position()).length())));
        for (ParticleFog particleFog : orderedFog) {
            ParticleFog.renderFog(particleFog, d3, d4, d5, matrix, partialTicks);
        }
    }

    public static void renderItems(LivingEntity living, ItemStack stack, ItemDisplayContext transformType, boolean applyLeftHandTransform, PoseStack p_115147_, MultiBufferSource p_115148_, int p_115149_, int p_115150_, BakedModel p_115151_) {
        if (!stack.isEmpty()) {
            BlockEntityWithoutLevelRenderer bewlr;
            p_115147_.pushPose();
            p_115151_ = ClientHooks.handleCameraTransforms((PoseStack)p_115147_, (BakedModel)p_115151_, (ItemDisplayContext)transformType, (boolean)applyLeftHandTransform);
            p_115147_.translate(-0.5, -0.5, -0.5);
            if (p_115151_.isCustomRenderer() && (bewlr = IClientItemExtensions.of((ItemStack)stack).getCustomRenderer()) instanceof IEntityAwareRenderer) {
                ((IEntityAwareRenderer)bewlr).render(living, stack, transformType, p_115147_, p_115148_, p_115149_, p_115150_);
            }
            p_115147_.popPose();
        }
    }

    public static void render(ItemStack stack, boolean m) {
        stack.set(DataComponents.SHOULD_RENDER_COMPONENT, (Object)m);
    }

    public static boolean shouldRender(ItemStack stack) {
        if (stack.has(DataComponents.SHOULD_RENDER_COMPONENT)) {
            return Boolean.TRUE.equals(stack.get(DataComponents.SHOULD_RENDER_COMPONENT));
        }
        return true;
    }

    public static RenderType renderSpiral(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type, float lengthen, float innerradius, float texs) {
        matrix.pushPose();
        Matrix4f positionMatrix = matrix.last().pose();
        VertexConsumer bb = buffer.getBuffer(type);
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double h2 = height;
        double r2 = radius;
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float squeeze = 3.0f;
        float texx = texs;
        double ygrow = cy;
        for (int i = 0; i < num_segments + 1; ++i) {
            r2 = innerradius + (radius - innerradius) * ((float)(num_segments - i) / (float)num_segments);
            h2 = height * ((float)(num_segments - i) / (float)num_segments);
            p = r2 + h2 * Math.cos(EffectUtil.toRad(flatness));
            q = h2 * Math.sin(EffectUtil.toRad(flatness));
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = 0.0f;
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                bb.addVertex(positionMatrix, (float)x, (float)y, (float)z).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lx, ly);
                bb.addVertex(positionMatrix, (float)xb, (float)yb, (float)zb).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lx, ly);
            }
            double tt = (double)i * theta;
            x = -r2 * Math.sin(tt);
            y = ygrow;
            z = r2 * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = ygrow - q;
            zb = p * Math.cos(tt);
            bb.addVertex(positionMatrix, (float)x, (float)y, (float)z).setColor(r, g, b, a).setUv(texx, 0.0f).setUv2(lx, ly);
            bb.addVertex(positionMatrix, (float)xb, (float)yb, (float)zb).setColor(r, g, b, a).setUv(texx, 1.0f).setUv2(lx, ly);
            ygrow += (double)lengthen;
        }
        matrix.popPose();
        return type;
    }

    public static RenderType renderCurvedSpiral(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type, float lengthen, float innerradius, float texs, float curve_start, float curve_end, int start) {
        matrix.pushPose();
        Matrix4f positionMatrix = matrix.last().pose();
        VertexConsumer bb = buffer.getBuffer(type);
        double pi = 3.1415926;
        double theta = 12.0 * pi / (double)num_segments;
        double curve_theta = (curve_end - curve_start) / (float)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double h2 = height;
        double r2 = radius;
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float seg_per_tex = 0.015625f;
        float texx = texs;
        double ygrow = cy;
        for (float i = 0.0f; i < (float)(num_segments + 1); i += 1.0f) {
            RenderUtils.rotateQ((float)(-curve_theta), 0.0f, 0.0f, 1.0f, matrix);
            r2 = innerradius + (radius - innerradius) * (((float)num_segments - i) / (float)num_segments);
            h2 = height * (((float)num_segments - i) / (float)num_segments);
            p = r2 + h2 * Math.cos(EffectUtil.toRad(flatness));
            q = h2 * Math.sin(EffectUtil.toRad(flatness));
            ygrow = cy + (double)(i * lengthen);
            texx = texs + i * seg_per_tex;
            double tt = (double)EffectUtil.toRad(start) + (double)i * theta;
            x = -r2 * Math.sin(tt);
            y = ygrow;
            z = r2 * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = ygrow - q;
            zb = p * Math.cos(tt);
            bb.addVertex(positionMatrix, (float)x, (float)y, (float)z).setColor(r, g, b, a).setUv(texx, 0.0f).setUv2(lx, ly);
            bb.addVertex(positionMatrix, (float)xb, (float)yb, (float)zb).setColor(r, g, b, a).setUv(texx, 1.0f).setUv2(lx, ly);
        }
        matrix.popPose();
        return type;
    }

    public static void billboard(PoseStack m, float r, float partialTicks) {
        Entity e = Minecraft.getInstance().getCameraEntity();
        if (e != null) {
            float yaw = e.yRotO + (e.getYRot() - e.yRotO) * partialTicks;
            float pitch = e.xRotO + (e.getXRot() - e.xRotO) * partialTicks;
            RenderUtils.rotateQ(360.0f - yaw, 0.0f, 1.0f, 0.0f, m);
            RenderUtils.rotateQ(pitch + 90.0f, 1.0f, 0.0f, 0.0f, m);
            RenderUtils.rotateQ(r, 0.0f, 1.0f, 0.0f, m);
        }
    }

    public static void conditionalBatchEnder(RenderType type, MultiBufferSource buf) {
        if (buf instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)buf).endBatch(type);
        }
    }

    public static Vec3 bezier(double t, Vec3 p0, Vec3 p1, Vec3 p2) {
        double m = (1.0 - t) * (1.0 - t);
        return p1.add(p0.subtract(p1).scale(m)).add(p2.subtract(p1).scale(t * t));
    }

    public static boolean turnOffMahouShaders() {
        return MahouTsukaiMod.shaders_on;
    }

    public static VertexConsumer addPoint(VertexConsumer buf, Matrix4f m, double x, double y, double z, float[] rgba) {
        return buf.addVertex(m, (float)x, (float)y, (float)z).setColor(rgba[0], rgba[1], rgba[2], rgba[3]);
    }
}

