/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.networking.ClientPacketHandler;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.util.ByteBufUtils;

public class InsightPacket
implements CustomPacketPayload {
    CompoundTag inventory;
    CompoundTag effects;
    int id;
    int mainhandindex;
    boolean hasTarget;
    boolean block;
    public static final StreamCodec<ByteBuf, InsightPacket> STREAM_CODEC = new StreamCodec<ByteBuf, InsightPacket>(){

        public InsightPacket decode(ByteBuf buf) {
            InsightPacket packet = new InsightPacket();
            packet.decode(buf);
            return packet;
        }

        public void encode(ByteBuf buf, InsightPacket packet) {
            packet.encode(buf);
        }
    };

    public InsightPacket() {
    }

    public InsightPacket(CompoundTag inv, CompoundTag effects, boolean hasTarget, boolean block, int eid, int mainhandindex) {
        this.inventory = inv;
        this.id = eid;
        this.block = block;
        this.hasTarget = hasTarget;
        this.effects = effects;
        this.mainhandindex = mainhandindex;
    }

    public void decode(ByteBuf buf) {
        this.id = buf.readInt();
        this.block = buf.readBoolean();
        this.hasTarget = buf.readBoolean();
        this.mainhandindex = buf.readInt();
        String s = ByteBufUtils.readUTF8String(buf);
        try {
            this.inventory = s == null ? new CompoundTag() : TagParser.parseTag((String)s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String s2 = ByteBufUtils.readUTF8String(buf);
        try {
            this.effects = s2 == null ? new CompoundTag() : TagParser.parseTag((String)s2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void encode(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.block);
        buf.writeBoolean(this.hasTarget);
        buf.writeInt(this.mainhandindex);
        String s = this.inventory.toString();
        ByteBufUtils.writeUTF8String(buf, s);
        String s2 = this.effects.toString();
        ByteBufUtils.writeUTF8String(buf, s2);
    }

    public static void handle(InsightPacket message, IPayloadContext context) {
        ClientPacketHandler.insightHandler(message, context.player().level());
    }

    public CustomPacketPayload.Type<InsightPacket> type() {
        return MahouPackets.INSIGHT_TYPE;
    }
}

