/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.lance;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import stepsword.jousting.item.ItemLance;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.lance.LanceMahou;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.entity.mahoujin.RhongomyniadEntity;
import stepsword.mahoutsukai.item.caliburn.Caliburn;
import stepsword.mahoutsukai.util.FakeSkeleton;
import stepsword.mahoutsukai.util.Utils;

public class Rhongomyniad
extends ItemLance {
    public static final ResourceLocation speedlance = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"rhongomyniad_speed");
    public static final String MT_ATTACK_DAMAGE = "mahoutsukai_rhongomyniad_attack";
    public static final String MT_WEIGHT = "mahoutsukai_rhongomyniad_weight";

    public Rhongomyniad() {
        super("rhongomyniad", null, () -> 1200, () -> 10.0, () -> 2.0);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        if (player.isDiscrete() && handIn == InteractionHand.MAIN_HAND && !worldIn.isClientSide) {
            BlockHitResult result = Rhongomyniad.getPlayerPOVHitResult((Level)worldIn, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (result != null && result.getBlockPos() != null) {
                ItemStack r = player.getMainHandItem().copy();
                RhongomyniadEntity rhongomyniad = new RhongomyniadEntity(worldIn, player, 1.0f, r);
                BlockPos p = result.getBlockPos().relative(result.getDirection());
                rhongomyniad.setPos((double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5);
                worldIn.addFreshEntity((Entity)rhongomyniad);
                player.getMainHandItem().shrink(1);
            }
            return InteractionResultHolder.success((Object)player.getMainHandItem());
        }
        return super.use(worldIn, player, handIn);
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.POWER_CONSOLIDATION_DURABILITY;
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
        if (stack.getItem() instanceof Rhongomyniad && player.getVehicle() != null && player.getVehicle() instanceof LivingEntity) {
            LivingEntity riding = (LivingEntity)player.getVehicle();
            if (!player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate((double)MTConfig.RHONGOMYNIAD_RANGE), b -> Caliburn.specialTarget(b)).isEmpty()) {
                Rhongomyniad.addspeed(riding, true);
            }
        }
        super.onUseTick(level, player, stack, count);
    }

    public static float simulateHit(ItemStack s, Level world) {
        float ret = 3.0f;
        int health = 5000000;
        if (s != null) {
            ItemStack s1 = s.copy();
            FakeSkeleton fake_target = new FakeSkeleton(world);
            fake_target.h = 5000000.0f;
            SafeFakePlayer fake_player = new SafeFakePlayer((ServerLevel)world, "faker");
            fake_player.setItemInHand(InteractionHand.MAIN_HAND, s1);
            Caliburn.updateAttr(s1, (Player)fake_player, EquipmentSlot.MAINHAND);
            ((Player)fake_player).attackStrengthTicker = 1000;
            if (s1.getItem() instanceof ItemLance) {
                ((ItemLance)s1.getItem()).attack((Player)fake_player, (Entity)fake_target);
            }
            ret = (float)health - fake_target.h;
        }
        return ret;
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity player, int timeLeft) {
        if (player.getVehicle() instanceof LivingEntity) {
            Rhongomyniad.addspeed((LivingEntity)player.getVehicle(), false);
        }
        super.releaseUsing(stack, worldIn, player, timeLeft);
    }

    public static void addspeed(LivingEntity living, boolean add) {
        AttributeModifier a = new AttributeModifier(speedlance, MTConfig.RHONGOMYNIAD_SPEED_FACTOR, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        AttributeInstance attr = living.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attr != null) {
            boolean hasSpeed = attr.hasModifier(speedlance);
            if (add) {
                if (!hasSpeed) {
                    attr.addTransientModifier(a);
                }
            } else if (hasSpeed) {
                attr.removeModifier(a);
            }
        }
    }

    public double getAttackDamage(ItemStack stack) {
        LanceMahou mahou;
        double damage = 1.0;
        if (stack != null && (mahou = Utils.getLanceMahou(stack)) != null) {
            damage += (double)mahou.getAttackDamage();
        }
        return damage;
    }

    public double getWeight(ItemStack stack) {
        LanceMahou mahou;
        double weight = 2.0;
        if (stack != null && (mahou = Utils.getLanceMahou(stack)) != null) {
            weight = mahou.getWeight();
        }
        return weight;
    }
}

