/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.lance.LanceMahou;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.SmiteEntity;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.caliburn.Caliburn;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class RhongomyniadEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_STACK = "MAHOUTSUKAI_STACK";
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.defineId(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.defineId(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.defineId(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.defineId(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.defineId(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.defineId(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.defineId(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final String entityName = "rhongomyniad_entity";
    boolean nocaster = false;
    public float py = 0.0f;
    public float yy = 0.0f;

    public RhongomyniadEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public RhongomyniadEntity(Level world) {
        super((EntityType)ModEntities.RHONGOMYNIAD.get(), world);
        this.noCulling = true;
    }

    public RhongomyniadEntity(Level world, Player caster, float size, ItemStack stack) {
        this(world);
        this.entityData.set(CASTER_UUID, Optional.of(caster.getUUID()));
        this.sizer(size);
        this.setStack(stack);
    }

    public RhongomyniadEntity(Level world, float size, ItemStack stack) {
        this(world);
        this.sizer(size);
        this.setStack(stack);
        this.nocaster = true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_SPEED, (Object)Float.valueOf(1.0f));
        builder.define(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(CASTER_UUID, Optional.empty());
        builder.define(STACK, (Object)ItemStack.EMPTY);
    }

    public static void rhongomyniadRightClick(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Entity e = event.getTarget();
        if (e instanceof RhongomyniadEntity) {
            RhongomyniadEntity re = (RhongomyniadEntity)e;
            if (!re.nocaster && !re.level().isClientSide && re.getCasterUUID() != null && player.getUUID().equals(re.getCasterUUID())) {
                if (re.getStack() != null && re.isAlive()) {
                    re.level().addFreshEntity((Entity)new ItemEntity(re.level(), re.getX(), re.getY(), re.getZ(), re.getStack()));
                    re.discard();
                } else {
                    re.discard();
                }
            }
        }
    }

    public void tick() {
        super.tick();
        this.py = this.yy;
        this.yRotO = this.yRot;
        if (this.yRotO < 0.0f) {
            this.yRotO += 360.0f;
        }
        if (this.py < 0.0f) {
            this.py += 360.0f;
        }
        this.yy += 1.0f;
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.yRot = this.getRotationYaw();
        this.xRot = this.getRotationPitch();
        this.setRot(this.yRot, this.xRot);
        if (!this.level().isClientSide) {
            this.setLife(this.getLife() + 1);
            if (this.getLife() % 40 == 0) {
                float range = 20.0f;
                if (this.nocaster || RhongomyniadEntity.operate(this.level(), this.getCasterUUID(), this.blockPosition())) {
                    AABB aabb = new AABB(this.getX() - (double)range, this.getY() - (double)range, this.getZ() - (double)range, this.getX() + (double)range, this.getY() + (double)range, this.getZ() + (double)range);
                    List lst = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
                    int max_smites = MTConfig.RHONGOMYNIAD_MAX_SMITES;
                    int smites = 0;
                    for (LivingEntity e : lst) {
                        boolean immune;
                        if (smites >= max_smites) continue;
                        boolean bl = immune = !this.nocaster && MTConfig.RHONGOMYNIAD_RESPECT_IMMUNE && ContractMahoujinTileEntity.isImmuneToSpell(e.level(), this.getCasterUUID(), (Entity)e);
                        if (!Caliburn.specialTarget(e) || immune) continue;
                        RhongomyniadEntity.strike(e, this);
                        ++smites;
                    }
                }
            }
        }
    }

    public static void strike(LivingEntity e, RhongomyniadEntity rhongo) {
        LanceMahou mahou = Utils.getLanceMahou(rhongo.getStack());
        float damage = mahou.getAttackDamage();
        SmiteEntity smite = new SmiteEntity(e.level(), e, 0.9019608f, 0.9019608f, 0.16470589f, 1.0f, 0.1f, damage);
        smite.setPos(e.getX(), e.getY(), e.getZ());
        e.level().addFreshEntity((Entity)smite);
    }

    public static boolean operate(Level world, UUID casterUUID, BlockPos pos) {
        int mana_drain = MTConfig.RHONGOMYNIAD_MANA_COST;
        if (casterUUID != null && pos != null && world != null) {
            boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(pos, world, casterUUID, mana_drain);
            Player caster = world.getPlayerByUUID(casterUUID);
            if (nearbyBatteriesGaveMana || caster != null && PlayerManaManager.drainMana(caster, mana_drain, false, true) == mana_drain) {
                return true;
            }
        }
        return false;
    }

    public static void rhongomyniadLivingHurt(LivingIncomingDamageEvent event) {
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().getEntity();
        if (source instanceof LivingEntity && !Caliburn.specialTarget(target)) {
            float range = MTConfig.RHONGOMYNIAD_RANGE;
            AABB aabb = new AABB(source.getX() - (double)range, source.getY() - (double)range, source.getZ() - (double)range, source.getX() + (double)range, source.getY() + (double)range, source.getZ() + (double)range);
            List lst = target.level().getEntitiesOfClass(RhongomyniadEntity.class, aabb);
            for (RhongomyniadEntity e : lst) {
                boolean immune;
                boolean bl = immune = e.nocaster && MTConfig.RHONGOMYNIAD_RESPECT_IMMUNE && ContractMahoujinTileEntity.isImmuneToSpell(e.level(), e.getCasterUUID(), source);
                if (!e.nocaster && (immune || !RhongomyniadEntity.operate(source.level(), e.getCasterUUID(), e.blockPosition()))) continue;
                RhongomyniadEntity.strike((LivingEntity)source, e);
            }
        }
    }

    public boolean isPickable() {
        return true;
    }

    public void playerTouch(Player entityIn) {
    }

    protected void checkInsideBlocks() {
    }

    public UUID getCasterUUID() {
        return ((Optional)this.entityData.get(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.entityData.set(CASTER_UUID, Optional.of(uuid));
    }

    public void sizer(float s) {
        this.setCircleSize(s);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setRotationYaw(compound.getFloat(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.getFloat(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.getFloat(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.getFloat(TAG_ROTATION_SPEED));
        this.setCircleSize(compound.getFloat(TAG_CIRCLE_SIZE));
        this.setLife(compound.getInt(TAG_LIFE));
        if (compound.hasUUID(TAG_CASTER)) {
            this.setCasterUUID(compound.getUUID(TAG_CASTER));
        }
        if (compound.contains(TAG_STACK)) {
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)compound.get(TAG_STACK)).orElse(ModItems.rhongomyniad == null ? ItemStack.EMPTY : new ItemStack((ItemLike)ModItems.rhongomyniad));
            stack.setCount(1);
            this.setStack(stack);
        }
        this.nocaster = compound.getBoolean("NO_CASTER");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.putFloat(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.putFloat(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.putFloat(TAG_ROTATION_SPEED, this.getRotationSpeed());
        compound.putFloat(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.putInt(TAG_LIFE, this.getLife());
        if (this.getCasterUUID() != null) {
            compound.putUUID(TAG_CASTER, this.getCasterUUID());
        }
        if (this.getStack() != null) {
            compound.put(TAG_STACK, this.getStack().save((HolderLookup.Provider)this.level().registryAccess()));
        }
        compound.putBoolean("NO_CASTER", this.nocaster);
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    public float getRotationYaw() {
        return ((Float)this.entityData.get(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.entityData.set(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.entityData.get(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.entityData.set(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.entityData.get(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.entityData.set(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.entityData.get(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.entityData.set(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.entityData.get(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.entityData.set(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public ItemStack getStack() {
        return (ItemStack)this.entityData.get(STACK);
    }

    public void setStack(ItemStack s) {
        this.entityData.set(STACK, (Object)s);
    }
}

