/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.displacement;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.Utils;

public class ProtectiveDisplacementSpellEffect {
    public static boolean addProtectionToUser(Player player) {
        IMahou mahou;
        if (player != null && (mahou = Utils.getPlayerMahou(player)) != null) {
            mahou.setProtectiveDisplacement(mahou.getProtectiveDisplacement() + 5);
            return true;
        }
        return false;
    }

    public static boolean protectiveDisplacementProjectileImpact(ProjectileImpactEvent event) {
        int protD;
        Player player;
        IMahou mahou;
        if (!event.getEntity().level().isClientSide && event.getRayTraceResult() != null && event.getRayTraceResult() instanceof EntityHitResult && ((EntityHitResult)event.getRayTraceResult()).getEntity() instanceof Player && (mahou = Utils.getPlayerMahou(player = (Player)((EntityHitResult)event.getRayTraceResult()).getEntity())) != null && (protD = mahou.getProtectiveDisplacement()) > 0) {
            for (int i = 0; i < 256 && !ProtectiveDisplacementSpellEffect.teleportRandomly(player, player.level()); ++i) {
            }
            mahou.setProtectiveDisplacement(protD - 1);
            return true;
        }
        return false;
    }

    protected static boolean teleportRandomly(Player player, Level world) {
        RandomSource rand = player.getRandom();
        double d0 = player.getX() + (rand.nextDouble() - 0.5) * 6.0;
        double d1 = player.getY() + (double)(rand.nextInt(4) - 2);
        double d2 = player.getZ() + (rand.nextDouble() - 0.5) * 6.0;
        return ProtectiveDisplacementSpellEffect.teleportTo(d0, d1, d2, player, world);
    }

    private static boolean teleportTo(double x, double y, double z, Player player, Level world) {
        boolean flag = ProtectiveDisplacementSpellEffect.attemptTeleport(x, y, z, player, world);
        if (flag) {
            world.playSound(null, player.xo, player.yo, player.zo, SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
        }
        return flag;
    }

    public static boolean attemptTeleport(double x, double y, double z, Player player, Level world) {
        double d0 = x;
        double d1 = y;
        double d2 = z;
        BlockPos bp = Utils.toBlockPos(new Vec3(d0, d1, d2));
        if (Utils.isBlockAir(world, bp.offset(0, 1, 0)) && Utils.isBlockAir(world, bp.offset(0, 2, 0)) && !Utils.isBlockAir(world, bp)) {
            MahouTsukaiTeleporter.teleport((Entity)player, d0, d1 + 1.0, d2, EffectUtil.getDimension(player.level()));
            return true;
        }
        return false;
    }
}

