/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.dataattachments.mahou;

import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.config.MandatoryFun;
import stepsword.mahoutsukai.dataattachments.DAUtils;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.util.BlockDim;
import stepsword.mahoutsukai.util.UnorderedList;

public class MahouStorage {
    private static String PLAYER_STORED_MANA = "MAHOUTSUKAI_PLAYER_STORED_MANA";
    private static String PLAYER_MAX_MANA = "MAHOUTSUKAI_PLAYER_MAX_MANA";
    private static String PLAYER_CHARGE_RATE = "MAHOUTSUKAI_PLAYER_CHARGE_RATE";
    private static String PLAYER_MANA_TO_USE_COUNTER = "MAHOUTSUKAI_MANA_UP_COUNTER";
    private static String PLAYER_FULL_MANA_FLAG = "MAHOUTSUKAI_MANA_FULL";
    private static String PLAYER_ENEMY = "MAHOUTSUKAI_PLAYER_ENEMY";
    private static String PLAYER_SAVED_SPAWN = "MAHOUTSUKAI_PLAYER_SAVED_SPAWN";
    private static String PLAYER_OLD_DIMENSION = "MAHOUTSUKAI_PLAYER_OLD_DIMENSION";
    private static String PLAYER_MARBLE_SPAWN = "MAHOUTSUKAI_PLAYER_MARBLE_SPAWN";
    private static String MEMORIZED_EDMTE = "MAHOUTSUKAI_PLAYER_MEMORIZED_EDMTE";
    private static String MENTAL_DISPLACEMENT = "MAHOUTSUKAI_PLAYER_MENTAL_DISPLACEMENT_ORIGINAL";
    private static String PLAYER_LAST_ARROW = "MAHOUTSUKAI_PLAYER_LAST_ARROW";
    private static String PROTECTIVE_DISPLACEMENT_USES = "MAHOUTSUKAI_PLAYER_PROTECTIVE_DISPLACEMENT_USES";
    private static String DAMAGE_EXCHANGE_USES = "MAHOUTSUKAI_PLAYER_DAMAGE_EXCHANGE_USES";
    private static String DEATH_COLLECTION_USES_LEFT = "MAHOUTSUKAI_PLAYER_DEATH_COLLECTION_USES_LEFT";
    private static String IS_POSSESSING = "MAHOUTSUKAI_PLAYER_POSSESSING";
    private static String DAMAGE_REPLICATION_TARGET = "MAHOUTSUKAI_PLAYER_DAMAGE_REPLICATION_TARGET";
    private static String HAS_MAGIC = "MAHOUTSUKAI_PLAYER_HAS_MAGIC";
    private static String PREV_YAW = "MAHOUTSUKAI_PLAYER_PREV_YAW";
    private static String PREV_PITCH = "MAHOUTSUKAI_PLAYER_PREV_PITCH";
    private static String LAST_RECIPE_CLOTH = "MAHOUTSUKAI_LAST_RECIPE_CLOTH";
    private static String LAST_RECIPE = "MAHOUTSUKAI_LAST_RECIPE";
    private static String PREV_EYE = "MAHOUTSUKAI_PLAYER_PREV_EYE";
    private static String INTERESTING = "MAHOUTSUKAI_FAMILIAR_INTERESTING_BLOCK";
    private static String CANCEL_TIME = "MAHOUTSUKAI_CANCEL_TIME";
    private static String IMMUNITY_DAMAGE_TYPE = "MAHOUTSUKAI_IMMUNITY_DAMAGE_TYPE";
    private static String VISIBLE = "MAHOUTSUKAI_SHOW_MAHOU";
    private static String FAE_SPAWN = "MAHOUTSUKAI_FAE_SPAWN";
    private static String GEAS = "MAHOUTSUKAI_GEAS";
    private static String PAGE = "MAHOUTSUKAI_PAGE";

    public static Tag writeNBT(IMahou instance) {
        Object order;
        UnorderedList lst;
        CompoundTag nbt = new CompoundTag();
        nbt.putInt(PLAYER_STORED_MANA, instance.getStoredMana());
        nbt.putInt(PLAYER_MAX_MANA, instance.getMaxMana());
        nbt.putDouble(PLAYER_CHARGE_RATE, instance.getChargeRate());
        nbt.putInt(PLAYER_MANA_TO_USE_COUNTER, instance.getManaToUseCounter());
        nbt.putBoolean(PLAYER_FULL_MANA_FLAG, instance.isManaFull());
        if (instance.getImmunityDamageType() != null) {
            nbt.putString(IMMUNITY_DAMAGE_TYPE, instance.getImmunityDamageType());
        }
        if (instance.getEnemy() != null) {
            nbt.putUUID(PLAYER_ENEMY, instance.getEnemy());
        }
        DAUtils.bpw(PLAYER_SAVED_SPAWN, instance.getPlayerSavedSpawn(), nbt);
        DAUtils.bpw(PLAYER_MARBLE_SPAWN, instance.getPlayerMarbleSpawn(), nbt);
        if (instance.getPlayerOldDimension() != null) {
            nbt.putString(PLAYER_OLD_DIMENSION, instance.getPlayerOldDimension());
        }
        if (instance.getMemorizedEDMTE() != null) {
            instance.getMemorizedEDMTE().write(MEMORIZED_EDMTE, nbt);
        }
        if (instance.getLastArrowShot() != null) {
            nbt.putUUID(PLAYER_LAST_ARROW, instance.getLastArrowShot());
        }
        DAUtils.bpw(MENTAL_DISPLACEMENT, instance.getMentalDisplacementPos(), nbt);
        nbt.putInt(PROTECTIVE_DISPLACEMENT_USES, instance.getProtectiveDisplacement());
        nbt.putInt(DAMAGE_EXCHANGE_USES, instance.getDamageExchangeUses());
        nbt.putFloat(DEATH_COLLECTION_USES_LEFT, instance.getDeathCollectionUsesLeft());
        nbt.putBoolean(IS_POSSESSING, instance.isPossessing());
        nbt.putBoolean(HAS_MAGIC, instance.hasMagic());
        nbt.putFloat(PREV_PITCH, instance.getPlayerPrevPitch());
        nbt.putFloat(PREV_YAW, instance.getPlayerPrevYaw());
        nbt = DAUtils.v3w(PREV_EYE, instance.getPlayerPrevEyePos(), nbt);
        nbt = DAUtils.bpw(INTERESTING, instance.getFamiliarInterestingBlock(), nbt);
        if (instance.getDamageReplicationTarget() != null) {
            nbt.putUUID(DAMAGE_REPLICATION_TARGET, instance.getDamageReplicationTarget());
        }
        if (instance.getLastRecipe() != null && (lst = instance.getLastRecipe()).size() == 3 && (order = lst.getOrder()) != null && order.size() == 3) {
            String s1 = (String)order.get(0);
            String s2 = (String)order.get(1);
            String s3 = (String)order.get(2);
            nbt.putString(LAST_RECIPE + "1", s1);
            nbt.putString(LAST_RECIPE + "2", s2);
            nbt.putString(LAST_RECIPE + "3", s3);
        }
        nbt.putBoolean(LAST_RECIPE_CLOTH, instance.getLastRecipeCloth());
        nbt.putLong(CANCEL_TIME, instance.getCancelTime());
        nbt.putBoolean(VISIBLE, instance.getVisible());
        nbt.putBoolean(FAE_SPAWN, instance.getFaeSpawn());
        if (instance.getGeas() != null) {
            int i = 0;
            for (String g : instance.getGeas()) {
                nbt.putString(GEAS + i, g);
                ++i;
            }
        }
        nbt.putInt(PAGE, instance.getGuidePage());
        if (instance.getMandatoryFun() != null) {
            for (String s : instance.getMandatoryFun().keySet()) {
                nbt.putBoolean(s, instance.getMandatoryFun().get(s).booleanValue());
            }
        }
        return nbt;
    }

    public static void readNBT(IMahou instance, Tag nbtb) {
        CompoundTag nbt = (CompoundTag)nbtb;
        instance.clearBuffs();
        instance.setChargeRate(nbt.getDouble(PLAYER_CHARGE_RATE));
        instance.setManaFull(nbt.getBoolean(PLAYER_FULL_MANA_FLAG));
        instance.setManaToUseCounter(nbt.getInt(PLAYER_MANA_TO_USE_COUNTER));
        instance.setMaxMana(nbt.getInt(PLAYER_MAX_MANA));
        if (nbt.contains(IMMUNITY_DAMAGE_TYPE)) {
            instance.setImmunityDamageType(nbt.getString(IMMUNITY_DAMAGE_TYPE));
        }
        instance.setStoredMana(nbt.getInt(PLAYER_STORED_MANA));
        instance.setPlayerSavedSpawn(DAUtils.bpr(PLAYER_SAVED_SPAWN, nbt));
        instance.setPlayerMarbleSpawn(DAUtils.bpr(PLAYER_MARBLE_SPAWN, nbt));
        instance.setFamiliarInterestingBlock(DAUtils.bpr(INTERESTING, nbt));
        if (nbt.contains(PLAYER_OLD_DIMENSION)) {
            instance.setPlayerOldDimension(nbt.getString(PLAYER_OLD_DIMENSION));
        }
        if (nbt.hasUUID(PLAYER_ENEMY)) {
            instance.setEnemy(nbt.getUUID(PLAYER_ENEMY));
        }
        if (nbt.hasUUID(PLAYER_LAST_ARROW)) {
            instance.setLastArrowShot(nbt.getUUID(PLAYER_LAST_ARROW));
        }
        instance.setMemorizedEDMTE(BlockDim.read(MEMORIZED_EDMTE, nbt));
        instance.setMentalDisplacementPos(DAUtils.bpr(MENTAL_DISPLACEMENT, nbt));
        instance.setPlayerPrevEyePos(DAUtils.v3r(PREV_EYE, nbt));
        instance.setProtectiveDisplacement(nbt.getInt(PROTECTIVE_DISPLACEMENT_USES));
        instance.setDamageExchangeUses(nbt.getInt(DAMAGE_EXCHANGE_USES));
        instance.setDeathCollectionUsesLeft(nbt.getFloat(DEATH_COLLECTION_USES_LEFT));
        instance.setPossessing(nbt.getBoolean(IS_POSSESSING));
        instance.setHasMagic(nbt.getBoolean(HAS_MAGIC));
        instance.setPlayerPrevPitch(nbt.getFloat(PREV_PITCH));
        instance.setPlayerPrevYaw(nbt.getFloat(PREV_YAW));
        if (nbt.hasUUID(DAMAGE_REPLICATION_TARGET)) {
            instance.setDamageReplicationTarget(nbt.getUUID(DAMAGE_REPLICATION_TARGET));
        } else {
            instance.setDamageReplicationTarget(null);
        }
        instance.setLastRecipeCloth(nbt.getBoolean(LAST_RECIPE_CLOTH));
        if (nbt.contains(LAST_RECIPE + "1") && nbt.contains(LAST_RECIPE + "2") && nbt.contains(LAST_RECIPE + "3")) {
            UnorderedList ul = MahoujinRecipeRegistrar.makeRecipe(nbt.getString(LAST_RECIPE + "1"), nbt.getString(LAST_RECIPE + "2"), nbt.getString(LAST_RECIPE + "3"));
            instance.setLastRecipe(ul);
        }
        instance.setCancelTime(nbt.getLong(CANCEL_TIME));
        if (nbt.contains(VISIBLE)) {
            instance.setVisible(nbt.getBoolean(VISIBLE));
        } else {
            instance.setVisible(true);
        }
        if (nbt.contains(FAE_SPAWN)) {
            instance.setFaeSpawn(nbt.getBoolean(FAE_SPAWN));
        } else {
            instance.setFaeSpawn(true);
        }
        HashSet<String> hs = new HashSet<String>();
        int b = 0;
        while (nbt.contains(GEAS + b)) {
            hs.add(nbt.getString(GEAS + b));
            ++b;
        }
        instance.setGeas(hs);
        instance.setGuidePage(nbt.getInt(PAGE));
        HashMap<String, Boolean> fun = new HashMap<String, Boolean>();
        for (MandatoryFun.FUN_REQS req : MandatoryFun.FUN_REQS.values()) {
            if (nbt.contains(req.name())) {
                fun.put(req.name(), nbt.getBoolean(req.name()));
                continue;
            }
            fun.put(req.name(), false);
        }
        instance.setMandatoryFun(fun);
    }
}

