/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.dataattachments.livingmahou.ILivingMahou;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ActingClientEffect {
    public static HashMap<LivingEntity, LivingEntity> actuals = new HashMap();

    public static void entityMap(LivingEntity e) {
        if (e.level().isClientSide) {
            if (ClientHandler.tint) {
                actuals.put(e, (LivingEntity)new Squid(EntityType.SQUID, (Level)Minecraft.getInstance().level));
            } else if (EffectUtil.hasBuff(e, ModEffects.ACTING)) {
                ILivingMahou mahou = Utils.getLivingMahou(e);
                int copyent = mahou.getActing();
                Entity ent = e.level().getEntity(copyent);
                if (ent instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)ent;
                    if (actuals == null) {
                        actuals = new HashMap();
                    }
                    actuals.put(e, living);
                }
            } else {
                actuals.remove(e);
            }
        }
    }

    public static void renderEntity(RenderLivingEvent.Pre event) {
        LivingEntity e = event.getEntity();
        if (actuals.containsKey(e)) {
            event.setCanceled(true);
            LivingEntity living = actuals.get(e);
            float f = Mth.lerp((float)event.getPartialTick(), (float)e.yRotO, (float)e.getYRot());
            ActingClientEffect.renderEntityStatic(e, living, 0.0, 0.0, 0.0, f, event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
        }
    }

    public static void renderEntityStatic(LivingEntity actor, LivingEntity entityIn, double xIn, double yIn, double zIn, float rotationYawIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        try {
            EntityRenderer entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entityIn);
            matrixStackIn.pushPose();
            LivingEntity newE = (LivingEntity)entityIn.getType().create(entityIn.level());
            if (entityIn instanceof AbstractClientPlayer) {
                newE = new RemotePlayer((ClientLevel)entityIn.level(), ((AbstractClientPlayer)entityIn).getGameProfile());
            }
            if (newE != null) {
                newE.copyPosition((Entity)actor);
                if (newE instanceof AbstractClientPlayer) {
                    AbstractClientPlayer newp = (AbstractClientPlayer)newE;
                    if (entityIn instanceof AbstractClientPlayer) {
                        AbstractClientPlayer abstractClientPlayer = (AbstractClientPlayer)entityIn;
                    }
                }
                for (AbstractClientPlayer e : EquipmentSlot.values()) {
                    newE.setItemSlot((EquipmentSlot)e, entityIn.getItemBySlot((EquipmentSlot)e).copy());
                }
                if (ClientHandler.tint) {
                    matrixStackIn.translate(0.0f, 1.0f, 0.0f);
                    if (newE instanceof Squid) {
                        float angle = Utils.mod(newE.level().getGameTime(), 180);
                        angle = 270.0f + (angle > 90.0f ? 180.0f - angle : angle);
                        ((Squid)newE).oldTentacleAngle = EffectUtil.toRad(-angle);
                        ((Squid)newE).tentacleAngle = EffectUtil.toRad(-angle);
                    }
                }
                newE.setYRot(actor.getYRot());
                newE.yRotO = actor.yRotO;
                newE.yBodyRotO = actor.yBodyRotO;
                newE.yHeadRotO = actor.yHeadRotO;
                newE.setYHeadRot(actor.getYHeadRot());
                newE.setYBodyRot(actor.yBodyRot);
                newE.copyAttachmentsFrom((Entity)entityIn, false);
                newE.setItemSlot(EquipmentSlot.MAINHAND, entityIn.getMainHandItem().copy());
                entityRenderer.render((Entity)newE, rotationYawIn, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.popPose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

