/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.grid;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mcjty.rftoolsbase.api.control.code.Opcode;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterDescription;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.Connection;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTools;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Opcodes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class GridInstance {
    private final String id;
    private final Connection primaryConnection;
    private final Connection secondaryConnection;
    private final List<Parameter> parameters;
    public static final Codec<GridInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(GridInstance::getId), (App)Connection.CODEC.optionalFieldOf("primary").forGetter(grid -> Optional.ofNullable(grid.getPrimaryConnection())), (App)Connection.CODEC.optionalFieldOf("secondary").forGetter(grid -> Optional.ofNullable(grid.getSecondaryConnection())), (App)Parameter.CODEC.listOf().fieldOf("parameters").forGetter(GridInstance::getParameters)).apply((Applicative)instance, GridInstance::createInstance));
    public static final StreamCodec<RegistryFriendlyByteBuf, GridInstance> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, GridInstance::getId, (StreamCodec)ByteBufCodecs.optional(Connection.STREAM_CODEC), grid -> Optional.ofNullable(grid.getPrimaryConnection()), (StreamCodec)ByteBufCodecs.optional(Connection.STREAM_CODEC), grid -> Optional.ofNullable(grid.getSecondaryConnection()), (StreamCodec)Parameter.STREAM_CODEC.apply(ByteBufCodecs.list()), GridInstance::getParameters, GridInstance::createInstance);

    private GridInstance(Builder builder) {
        this.id = builder.id;
        this.primaryConnection = builder.primaryConnection;
        this.secondaryConnection = builder.secondaryConnection;
        this.parameters = List.copyOf(builder.parameters);
    }

    public String getId() {
        return this.id;
    }

    public Connection getPrimaryConnection() {
        return this.primaryConnection;
    }

    public Connection getSecondaryConnection() {
        return this.secondaryConnection;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public JsonElement getJsonElement() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("id", (JsonElement)new JsonPrimitive(this.getId()));
        if (this.primaryConnection != null) {
            jsonObject.add("primary", (JsonElement)new JsonPrimitive(this.primaryConnection.getId()));
        }
        if (this.secondaryConnection != null) {
            jsonObject.add("secondary", (JsonElement)new JsonPrimitive(this.secondaryConnection.getId()));
        }
        JsonArray array = new JsonArray();
        for (Parameter parameter : this.getParameters()) {
            array.add(ParameterTools.getJsonElement(parameter));
        }
        jsonObject.add("parameters", (JsonElement)array);
        return jsonObject;
    }

    public static GridInstance readFromJson(JsonElement element) {
        Opcode opcode;
        JsonObject gridObject = element.getAsJsonObject();
        String id = gridObject.get("id").getAsString();
        Builder builder = GridInstance.builder(id);
        if (gridObject.has("primary")) {
            String primary = gridObject.get("primary").getAsString();
            builder.primaryConnection(Connection.getConnection(primary));
        }
        if (gridObject.has("secondary")) {
            String secondary = gridObject.get("secondary").getAsString();
            builder.secondaryConnection(Connection.getConnection(secondary));
        }
        if ((opcode = Opcodes.OPCODES.get(id)) == null) {
            return null;
        }
        JsonArray parameterArray = gridObject.get("parameters").getAsJsonArray();
        ArrayList<Parameter> decodedParameters = new ArrayList<Parameter>(parameterArray.size());
        for (JsonElement jsonParameterElement : parameterArray) {
            JsonObject parObject = jsonParameterElement.getAsJsonObject();
            decodedParameters.add(ParameterTools.readFromJson(parObject));
        }
        GridInstance.addParameters(builder, opcode, decodedParameters);
        return builder.build();
    }

    private static GridInstance createInstance(String id, Optional<Connection> primary, Optional<Connection> secondary, List<Parameter> parameters) {
        Builder builder = GridInstance.builder(id);
        primary.ifPresent(builder::primaryConnection);
        secondary.ifPresent(builder::secondaryConnection);
        GridInstance.addParameters(builder, id, parameters);
        return builder.build();
    }

    private static void addParameters(Builder builder, String opcodeId, List<Parameter> parameters) {
        GridInstance.addParameters(builder, Opcodes.OPCODES.get(opcodeId), parameters);
    }

    private static void addParameters(Builder builder, Opcode opcode, List<Parameter> parameters) {
        if (opcode == null) {
            return;
        }
        if (parameters == null) {
            return;
        }
        List descriptions = opcode.getParameters();
        int limit = Math.min(parameters.size(), descriptions.size());
        for (int i = 0; i < limit; ++i) {
            Parameter parameter = parameters.get(i);
            ParameterDescription description = (ParameterDescription)descriptions.get(i);
            if (parameter == null || parameter.getParameterType() != description.getType()) {
                builder.parameter(Parameter.builder().type(description.getType()).value(ParameterValue.constant(null)).build());
                continue;
            }
            builder.parameter(parameter);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridInstance that = (GridInstance)o;
        return Objects.equals(this.id, that.id) && Objects.equals((Object)this.primaryConnection, (Object)that.primaryConnection) && Objects.equals((Object)this.secondaryConnection, (Object)that.secondaryConnection) && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.primaryConnection, this.secondaryConnection, this.parameters});
    }

    public static class Builder {
        private final String id;
        private Connection primaryConnection;
        private Connection secondaryConnection;
        private final List<Parameter> parameters = new ArrayList<Parameter>();

        public Builder(String id) {
            this.id = id;
        }

        public Builder primaryConnection(Connection primaryConnection) {
            this.primaryConnection = primaryConnection;
            return this;
        }

        public Builder secondaryConnection(Connection secondaryConnection) {
            this.secondaryConnection = secondaryConnection;
            return this;
        }

        public Builder parameter(Parameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public GridInstance build() {
            return new GridInstance(this);
        }
    }
}

