/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.multitank.client;

import javax.annotation.Nonnull;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.VerticalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.modules.multitank.MultiTankModule;
import mcjty.rftoolscontrol.modules.multitank.blocks.MultiTankTileEntity;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankFluidProperties;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class GuiMultiTank
extends GenericGuiContainer<MultiTankTileEntity, GenericContainer> {
    public static final int WIDTH = 180;
    public static final int HEIGHT = 87;
    private static final ResourceLocation iconLocation = ResourceLocation.fromNamespaceAndPath((String)"rftoolscontrol", (String)"textures/gui/tank.png");
    private int listDirty = 0;
    private final BlockRender[] liquids = new BlockRender[4];
    private final Label[] labels = new Label[4];

    public GuiMultiTank(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ManualEntry.EMPTY);
        this.imageWidth = 180;
        this.imageHeight = 87;
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(MultiTankModule.MULTITANK_CONTAINER.get(), GuiMultiTank::new);
    }

    public void init() {
        super.init();
        Panel toplevel = (Panel)Widgets.positional().background(iconLocation);
        toplevel.bounds(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        for (int i = 0; i < 4; ++i) {
            this.liquids[i] = (BlockRender)new BlockRender().hint(10, 9 + i * 18, 16, 16);
            toplevel.children(new Widget[]{this.liquids[i]});
            this.labels[i] = (Label)((Label)Widgets.label((int)32, (int)(9 + i * 18), (int)142, (int)16, (String)"").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).verticalAlignment(VerticalAlignment.ALIGN_CENTER);
            toplevel.children(new Widget[]{this.labels[i]});
        }
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void requestLists() {
        GenericTileEntity be = this.getBE();
        Networking.sendToServer((CustomPacketPayload)PacketGetListFromServer.create((BlockPos)be.getBlockPos(), (String)MultiTankTileEntity.CMD_GETFLUIDS.name()));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestLists();
            this.listDirty = 10;
        }
    }

    private void updateLiquids() {
        this.requestListsIfNeeded();
        MultiTankTileEntity be = (MultiTankTileEntity)this.getBE();
        MultiTankFluidProperties[] properties = be.getProperties();
        for (int i = 0; i < 4; ++i) {
            FluidStack stack;
            if (i < properties.length && properties[i] != null && !(stack = properties[i].getContents()).isEmpty()) {
                this.liquids[i].renderItem((Object)stack);
                this.labels[i].text(stack.getDisplayName().getString() + " (" + stack.getAmount() + "mb)");
                continue;
            }
            this.liquids[i].renderItem(null);
            this.labels[i].text("");
        }
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.updateLiquids();
        this.drawWindow(graphics, partialTicks, mouseX, mouseY);
    }
}

