/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.buffer;

import codechicken.lib.render.buffer.DelegatingVertexConsumer;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;

public class TransformingVertexConsumer
extends DelegatingVertexConsumer {
    private final Transformation transform;
    private final Vector3 storage = new Vector3();

    public TransformingVertexConsumer(VertexConsumer delegate, PoseStack stack) {
        this(delegate, new Matrix4(stack));
    }

    public TransformingVertexConsumer(VertexConsumer delegate, Transformation transform) {
        super(delegate);
        this.transform = transform;
    }

    @Override
    public VertexConsumer addVertex(float x, float y, float z) {
        this.storage.set(x, y, z);
        this.transform.apply(this.storage);
        return super.addVertex((float)this.storage.x, (float)this.storage.y, (float)this.storage.z);
    }

    @Override
    public VertexConsumer setNormal(float x, float y, float z) {
        this.storage.set(x, y, z);
        this.transform.applyN(this.storage);
        return this.delegate.setNormal((float)this.storage.x, (float)this.storage.y, (float)this.storage.z);
    }
}

