/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.sprite.GuiTextures;
import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.util.FormatUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiFluidTank
extends GuiElement<GuiFluidTank>
implements BackgroundRender {
    public static final Material DEFAULT_WINDOW = GuiTextures.CCL.getUncached("widgets/tank_window");
    private int gaugeColour = -7303024;
    private boolean drawGauge = true;
    private Material window = null;
    private Supplier<Long> capacity = () -> 10000L;
    private Supplier<FluidStack> fluidStack = () -> FluidStack.EMPTY;
    private BiFunction<FluidStack, Long, List<Component>> toolTipFormatter;

    public GuiFluidTank(@NotNull GuiParent<?> parent) {
        super(parent);
        this.setTooltipDelay(0);
        this.setToolTipFormatter(GuiFluidTank.defaultFormatter());
    }

    public static FluidTank simpleTank(@NotNull GuiParent<?> parent) {
        GuiRectangle container = GuiRectangle.vanillaSlot(parent);
        GuiFluidTank energyBar = new GuiFluidTank(container);
        Constraints.bind(energyBar, container, 1.0);
        return new FluidTank(container, energyBar);
    }

    public GuiFluidTank setCapacity(long capacity) {
        return this.setCapacity(() -> capacity);
    }

    public GuiFluidTank setCapacity(Supplier<Long> capacity) {
        this.capacity = capacity;
        return this;
    }

    public GuiFluidTank setFluidStack(FluidStack fluidStack) {
        return this.setFluidStack(() -> fluidStack);
    }

    public GuiFluidTank setFluidStack(Supplier<FluidStack> fluidStack) {
        this.fluidStack = fluidStack;
        return this;
    }

    public GuiFluidTank setToolTipFormatter(BiFunction<FluidStack, Long, List<Component>> toolTipFormatter) {
        this.toolTipFormatter = toolTipFormatter;
        this.setTooltip(() -> this.toolTipFormatter.apply(this.getFluidStack(), this.getCapacity()));
        return this;
    }

    public GuiFluidTank setWindow(@Nullable Material window) {
        this.window = window;
        return this;
    }

    public GuiFluidTank setDrawGauge(boolean drawGauge) {
        this.drawGauge = drawGauge;
        return this;
    }

    public GuiFluidTank setGaugeColour(int gaugeColour) {
        this.gaugeColour = gaugeColour;
        return this;
    }

    public Long getCapacity() {
        return this.capacity.get();
    }

    public FluidStack getFluidStack() {
        return this.fluidStack.get();
    }

    @Override
    public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        FluidStack stack = this.getFluidStack();
        Material fluidMat = Material.fromSprite(GuiFluidTank.getStillTexture(stack));
        if (!stack.isEmpty() && fluidMat != null) {
            int fluidColor = GuiFluidTank.getColour(stack);
            float height = this.getCapacity() <= 0L ? 0.0f : (float)this.ySize() * ((float)stack.getAmount() / (float)this.getCapacity().longValue());
            render.tileSprite(fluidMat.renderType(GuiRender::texColType), this.xMin(), this.yMax() - (double)height, this.xMax(), this.yMax(), fluidMat.sprite(), fluidColor);
        }
        if (this.window != null) {
            render.tileSprite(this.window.renderType(GuiRender::texColType), this.xMin(), this.yMin(), this.xMax(), this.yMax(), this.window.sprite(), -1);
        }
        this.gaugeColour = -16777216;
        if (this.drawGauge) {
            double spacing = this.computeGaugeSpacing();
            if (spacing == 0.0) {
                return;
            }
            double pos = spacing;
            while (pos + 1.0 < this.ySize()) {
                double width = this.xSize() / 4.0;
                double yPos = this.yMax() - 1.0 - pos;
                render.fill(this.xMax() - width, yPos, this.xMax(), yPos + 1.0, this.gaugeColour);
                pos += spacing;
            }
        }
    }

    private double computeGaugeSpacing() {
        double capacity;
        double ySize = this.ySize();
        if (ySize / ((capacity = (double)this.getCapacity().longValue()) / 100.0) > 3.0) {
            return ySize / (capacity / 100.0);
        }
        if (ySize / (capacity / 500.0) > 3.0) {
            return ySize / (capacity / 500.0);
        }
        if (ySize / (capacity / 1000.0) > 3.0) {
            return ySize / (capacity / 1000.0);
        }
        if (ySize / (capacity / 5000.0) > 3.0) {
            return ySize / (capacity / 5000.0);
        }
        if (ySize / (capacity / 10000.0) > 3.0) {
            return ySize / (capacity / 10000.0);
        }
        if (ySize / (capacity / 50000.0) > 3.0) {
            return ySize / (capacity / 50000.0);
        }
        if (ySize / (capacity / 100000.0) > 3.0) {
            return ySize / (capacity / 100000.0);
        }
        return 0.0;
    }

    public static BiFunction<FluidStack, Long, List<Component>> defaultFormatter() {
        return (fluidStack, capacity) -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"ccl.fluid_tank.fluid_storage").withStyle(ChatFormatting.DARK_AQUA));
            if (!fluidStack.isEmpty()) {
                tooltip.add(Component.translatable((String)"ccl.fluid_tank.contains").withStyle(ChatFormatting.GOLD).append(" ").append((Component)fluidStack.getDisplayName().copy().setStyle(Style.EMPTY.withColor(GuiFluidTank.getColour(fluidStack)))));
            }
            tooltip.add(Component.translatable((String)"ccl.fluid_tank.capacity").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)FormatUtil.addCommas(capacity)).withStyle(ChatFormatting.GRAY).append(" ").append((Component)Component.translatable((String)"ccl.fluid_tank.mb").withStyle(ChatFormatting.GRAY))));
            tooltip.add(Component.translatable((String)"ccl.fluid_tank.stored").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)FormatUtil.addCommas(fluidStack.getAmount())).withStyle(ChatFormatting.GRAY)).append(" ").append((Component)Component.translatable((String)"ccl.fluid_tank.mb").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.format(" (%.2f%%)", (double)fluidStack.getAmount() / (double)capacity.longValue() * 100.0)).withStyle(ChatFormatting.GRAY)));
            return tooltip;
        };
    }

    public static int getColour(FluidStack fluidStack) {
        return fluidStack.getFluid() == Fluids.EMPTY ? -1 : IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
    }

    public static int getColour(Fluid fluid) {
        return fluid == Fluids.EMPTY ? -1 : IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
    }

    @Nullable
    public static TextureAtlasSprite getStillTexture(FluidStack stack) {
        if (stack.getFluid() == Fluids.EMPTY) {
            return null;
        }
        ResourceLocation texture = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getStillTexture(stack);
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(texture);
    }

    @Nullable
    public static TextureAtlasSprite getStillTexture(Fluid fluid) {
        if (fluid == Fluids.EMPTY) {
            return null;
        }
        ResourceLocation texture = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture();
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(texture);
    }

    public record FluidTank(GuiRectangle container, GuiFluidTank tank) {
    }
}

