/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.api.orientation.RelativeSide;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.networking.CrystalResonanceGeneratorBlockEntity;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrystalResonanceGeneratorBlock
extends AEBaseEntityBlock<CrystalResonanceGeneratorBlockEntity>
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public CrystalResonanceGeneratorBlock() {
        super(CrystalResonanceGeneratorBlock.glassProps().noOcclusion().forceSolidOn());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    @NotNull
    private VoxelShape getVoxelShape(BlockState state) {
        BlockOrientation orientation = this.getOrientation(state);
        Direction forward = orientation.getSide(RelativeSide.FRONT);
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        switch (forward) {
            case DOWN: {
                minX = 0.125;
                minZ = 0.125;
                maxX = 0.875;
                maxZ = 0.875;
                maxY = 1.0;
                minY = 0.0625;
                break;
            }
            case EAST: {
                minY = 0.125;
                minZ = 0.125;
                maxY = 0.875;
                maxZ = 0.875;
                maxX = 0.9375;
                minX = 0.0;
                break;
            }
            case NORTH: {
                minX = 0.125;
                minY = 0.125;
                maxX = 0.875;
                maxY = 0.875;
                maxZ = 1.0;
                minZ = 0.0625;
                break;
            }
            case SOUTH: {
                minX = 0.125;
                minY = 0.125;
                maxX = 0.875;
                maxY = 0.875;
                maxZ = 0.9375;
                minZ = 0.0;
                break;
            }
            case UP: {
                minX = 0.125;
                minZ = 0.125;
                maxX = 0.875;
                maxZ = 0.875;
                maxY = 0.9375;
                minY = 0.0;
                break;
            }
            case WEST: {
                minY = 0.125;
                minZ = 0.125;
                maxY = 0.875;
                maxZ = 0.875;
                maxX = 1.0;
                minX = 0.0625;
                break;
            }
        }
        return Shapes.create((AABB)new AABB(minX, minY, minZ, maxX, maxY, maxZ));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.facing();
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    public BlockState updateShape(BlockState blockState, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(blockState, facing, facingState, level, currentPos, facingPos);
    }

    public static enum State implements StringRepresentable
    {
        OFF,
        ON,
        HAS_CHANNEL;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

