/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.redstonelinkwildcard;

import com.hlysine.create_connected.CCItems;
import com.hlysine.create_connected.CreateConnected;
import com.hlysine.create_connected.config.CServer;
import com.hlysine.create_connected.config.FeatureToggle;
import com.hlysine.create_connected.content.redstonelinkwildcard.ILinkWildcard;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.levelWrappers.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="create_connected")
public class LinkWildcardNetworkHandler {
    static final Map<LevelAccessor, Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>>> transmitter_connections = new IdentityHashMap<LevelAccessor, Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>>>();
    static final Map<LevelAccessor, Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>>> receiver_connections = new IdentityHashMap<LevelAccessor, Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>>>();

    @SubscribeEvent
    public static void onLoadWorld(LevelEvent.Load event) {
        transmitter_connections.put(event.getLevel(), new HashMap());
        receiver_connections.put(event.getLevel(), new HashMap());
        CreateConnected.LOGGER.debug("Link-Wildcard: Prepared Redstone Network Wildcards for {}", (Object)WorldHelper.getDimensionID((LevelAccessor)event.getLevel()));
    }

    @SubscribeEvent
    public static void onUnloadWorld(LevelEvent.Unload event) {
        transmitter_connections.remove(event.getLevel());
        receiver_connections.remove(event.getLevel());
        CreateConnected.LOGGER.debug("Link-Wildcard: Removed Redstone Network Wildcards for {}", (Object)WorldHelper.getDimensionID((LevelAccessor)event.getLevel()));
    }

    public static Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>> transmittersIn(LevelAccessor world) {
        if (!transmitter_connections.containsKey(world)) {
            CreateConnected.LOGGER.warn("Link-Wildcard: Tried to Access unprepared network transmitters of {}", (Object)WorldHelper.getDimensionID((LevelAccessor)world));
            return new HashMap<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>>();
        }
        return transmitter_connections.get(world);
    }

    public static Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>> receiversIn(LevelAccessor world) {
        if (!receiver_connections.containsKey(world)) {
            CreateConnected.LOGGER.warn("Link-Wildcard: Tried to Access unprepared network receivers of {}", (Object)WorldHelper.getDimensionID((LevelAccessor)world));
            return new HashMap<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>>();
        }
        return receiver_connections.get(world);
    }

    public static boolean updateNetworkOf(RedstoneLinkNetworkHandler handler, LevelAccessor world, IRedstoneLinkable actor) {
        if (!FeatureToggle.isEnabled(CCItems.REDSTONE_LINK_WILDCARD.getId())) {
            return false;
        }
        Couple key = actor.getNetworkKey();
        LinkWildcardNetworkHandler.updateNetworkForReceiver(handler, world, actor, (Couple<RedstoneLinkNetworkHandler.Frequency>)key);
        if (actor.isListening()) {
            return true;
        }
        Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>> transmitters = LinkWildcardNetworkHandler.transmittersIn(world);
        if (transmitters.containsKey(key)) {
            Set<Couple<RedstoneLinkNetworkHandler.Frequency>> connections = transmitters.get(key);
            for (Couple<RedstoneLinkNetworkHandler.Frequency> connection : connections) {
                LinkWildcardNetworkHandler.updateNetworkForReceiver(handler, world, actor, connection);
            }
        }
        return true;
    }

    private static void updateNetworkForReceiver(RedstoneLinkNetworkHandler handler, LevelAccessor world, IRedstoneLinkable actor, Couple<RedstoneLinkNetworkHandler.Frequency> key) {
        LinkBehaviour linkBehaviour;
        Map networksInWorld = handler.networksIn(world);
        Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>> receiversInWorld = LinkWildcardNetworkHandler.receiversIn(world);
        Set network = (Set)networksInWorld.get(key);
        Set<Couple<RedstoneLinkNetworkHandler.Frequency>> receivers = receiversInWorld.get(key);
        handler.globalPowerVersion.incrementAndGet();
        AtomicInteger power = new AtomicInteger(0);
        Consumer<Set> updatePower = set -> {
            if (set == null || set.isEmpty()) {
                return;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IRedstoneLinkable other = (IRedstoneLinkable)iterator.next();
                if (!other.isAlive()) {
                    iterator.remove();
                    continue;
                }
                if (actor.isListening() || !RedstoneLinkNetworkHandler.withinRange((IRedstoneLinkable)actor, (IRedstoneLinkable)other) || power.get() >= 15) continue;
                power.accumulateAndGet(other.getTransmittedStrength(), Math::max);
            }
        };
        updatePower.accept(network);
        if (receivers != null) {
            for (Couple<RedstoneLinkNetworkHandler.Frequency> wildcard : receivers) {
                Set wildcardNetwork = (Set)networksInWorld.get(wildcard);
                updatePower.accept(wildcardNetwork);
            }
        }
        if (actor instanceof LinkBehaviour && (linkBehaviour = (LinkBehaviour)actor).isListening()) {
            linkBehaviour.newPosition = true;
            linkBehaviour.setReceivedStrength(power.get());
        }
        if (network != null && !network.isEmpty()) {
            for (IRedstoneLinkable other : network) {
                if (other == actor || !other.isListening() || !RedstoneLinkNetworkHandler.withinRange((IRedstoneLinkable)actor, (IRedstoneLinkable)other)) continue;
                other.setReceivedStrength(power.get());
            }
        }
    }

    public static void addToNetwork(RedstoneLinkNetworkHandler handler, LevelAccessor world, IRedstoneLinkable actor) {
        Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>> wildcards;
        Couple key = actor.getNetworkKey();
        Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>> map = wildcards = actor.isListening() ? LinkWildcardNetworkHandler.receiversIn(world) : LinkWildcardNetworkHandler.transmittersIn(world);
        if (!wildcards.containsKey(key)) {
            LinkedHashSet<Couple> connections = new LinkedHashSet<Couple>();
            Map networks = handler.networksIn(world);
            for (Couple otherKey : networks.keySet()) {
                if (!otherKey.equals((Object)key) && LinkWildcardNetworkHandler.test((Couple<RedstoneLinkNetworkHandler.Frequency>)key, (Couple<RedstoneLinkNetworkHandler.Frequency>)otherKey) && !connections.add(otherKey)) continue;
            }
            wildcards.put((Couple<RedstoneLinkNetworkHandler.Frequency>)key, connections);
        }
        Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>> oppositeSet = actor.isListening() ? LinkWildcardNetworkHandler.transmittersIn(world) : LinkWildcardNetworkHandler.receiversIn(world);
        for (Map.Entry<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>> entry : oppositeSet.entrySet()) {
            if (!entry.getKey().equals((Object)key) && LinkWildcardNetworkHandler.test(entry.getKey(), (Couple<RedstoneLinkNetworkHandler.Frequency>)key) && !entry.getValue().add((Couple<RedstoneLinkNetworkHandler.Frequency>)key)) continue;
        }
    }

    public static void removeFromNetwork(RedstoneLinkNetworkHandler handler, LevelAccessor world, final IRedstoneLinkable actor) {
        Couple key = actor.getNetworkKey();
        Map networks = handler.networksIn(world);
        if (networks.containsKey(key) && !((Set)networks.get(key)).isEmpty()) {
            return;
        }
        Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>> wildcards = actor.isListening() ? LinkWildcardNetworkHandler.receiversIn(world) : LinkWildcardNetworkHandler.transmittersIn(world);
        wildcards.remove(key);
        Map<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>> oppositeSet = actor.isListening() ? LinkWildcardNetworkHandler.transmittersIn(world) : LinkWildcardNetworkHandler.receiversIn(world);
        for (final Map.Entry<Couple<RedstoneLinkNetworkHandler.Frequency>, Set<Couple<RedstoneLinkNetworkHandler.Frequency>>> entry : oppositeSet.entrySet()) {
            if (!entry.getValue().remove(key)) continue;
            handler.updateNetworkOf(world, new IRedstoneLinkable(){

                public int getTransmittedStrength() {
                    return 0;
                }

                public void setReceivedStrength(int power) {
                }

                public boolean isListening() {
                    return false;
                }

                public boolean isAlive() {
                    return true;
                }

                public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
                    return (Couple)entry.getKey();
                }

                public BlockPos getLocation() {
                    return actor.getLocation();
                }
            });
        }
        if (actor.isListening()) {
            actor.setReceivedStrength(0);
        }
    }

    private static String keyToString(Couple<RedstoneLinkNetworkHandler.Frequency> key) {
        return String.format("%s + %s", BuiltInRegistries.ITEM.getKey((Object)((RedstoneLinkNetworkHandler.Frequency)key.getFirst()).getStack().getItem()), BuiltInRegistries.ITEM.getKey((Object)((RedstoneLinkNetworkHandler.Frequency)key.getSecond()).getStack().getItem()));
    }

    private static boolean test(Couple<RedstoneLinkNetworkHandler.Frequency> transmitter, Couple<RedstoneLinkNetworkHandler.Frequency> receiver) {
        if (!CServer.AllowDualWildcardLink.get().booleanValue() && ((RedstoneLinkNetworkHandler.Frequency)transmitter.getFirst()).getStack().getItem() instanceof ILinkWildcard && ((RedstoneLinkNetworkHandler.Frequency)transmitter.getSecond()).getStack().getItem() instanceof ILinkWildcard) {
            return false;
        }
        if (!CServer.AllowDualWildcardLink.get().booleanValue() && ((RedstoneLinkNetworkHandler.Frequency)receiver.getFirst()).getStack().getItem() instanceof ILinkWildcard && ((RedstoneLinkNetworkHandler.Frequency)receiver.getSecond()).getStack().getItem() instanceof ILinkWildcard) {
            return false;
        }
        return LinkWildcardNetworkHandler.wildcardTransmit((RedstoneLinkNetworkHandler.Frequency)transmitter.getFirst(), (RedstoneLinkNetworkHandler.Frequency)receiver.getFirst()) && LinkWildcardNetworkHandler.wildcardTransmit((RedstoneLinkNetworkHandler.Frequency)transmitter.getSecond(), (RedstoneLinkNetworkHandler.Frequency)receiver.getSecond()) || LinkWildcardNetworkHandler.wildcardReceive((RedstoneLinkNetworkHandler.Frequency)transmitter.getFirst(), (RedstoneLinkNetworkHandler.Frequency)receiver.getFirst()) && LinkWildcardNetworkHandler.wildcardReceive((RedstoneLinkNetworkHandler.Frequency)transmitter.getSecond(), (RedstoneLinkNetworkHandler.Frequency)receiver.getSecond());
    }

    private static boolean wildcardTransmit(RedstoneLinkNetworkHandler.Frequency transmitter, RedstoneLinkNetworkHandler.Frequency receiver) {
        Item item = transmitter.getStack().getItem();
        if (item instanceof ILinkWildcard) {
            ILinkWildcard wildcard = (ILinkWildcard)item;
            return wildcard.test(receiver);
        }
        return transmitter.equals((Object)receiver);
    }

    private static boolean wildcardReceive(RedstoneLinkNetworkHandler.Frequency transmitter, RedstoneLinkNetworkHandler.Frequency receiver) {
        Item item = receiver.getStack().getItem();
        if (item instanceof ILinkWildcard) {
            ILinkWildcard wildcard = (ILinkWildcard)item;
            return wildcard.test(transmitter);
        }
        return transmitter.equals((Object)receiver);
    }
}

