/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.mekanism.recipe.component;

import dev.latvian.mods.kubejs.mekanism.MekanismChemicalWrapper;
import dev.latvian.mods.kubejs.mekanism.recipe.component.ChemicalLikeRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import java.util.List;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.CompoundChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.TagChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;

public class ChemicalIngredientRecipeComponent
extends ChemicalLikeRecipeComponent<ChemicalIngredient> {
    public static final RecipeComponentType<ChemicalIngredient> CHEMICAL_INGREDIENT = RecipeComponentType.unit((ResourceLocation)Mekanism.rl((String)"chemical_ingredient"), t -> new ChemicalIngredientRecipeComponent((RecipeComponentType<?>)t, false));
    public static final RecipeComponentType<ChemicalIngredient> OPTIONAL_CHEMICAL_INGREDIENT = RecipeComponentType.unit((ResourceLocation)Mekanism.rl((String)"optional_chemical_ingredient"), t -> new ChemicalIngredientRecipeComponent((RecipeComponentType<?>)t, true));

    private ChemicalIngredientRecipeComponent(RecipeComponentType<?> type, boolean allowEmpty) {
        super(type, allowEmpty ? IngredientCreatorAccess.chemical().codec() : IngredientCreatorAccess.chemical().codecNonEmpty(), MekanismChemicalWrapper.CHEMICAL_INGREDIENT_TYPE_INFO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(RecipeMatchContext cx, ChemicalIngredient value, ReplacementMatchInfo match) {
        ReplacementMatch replacementMatch = match.match();
        if (!(replacementMatch instanceof ChemicalIngredient)) return false;
        ChemicalIngredient m = (ChemicalIngredient)replacementMatch;
        if (value.isEmpty()) return false;
        if (!value.getChemicalHolders().stream().anyMatch(arg_0 -> ((ChemicalIngredient)m).test(arg_0))) return false;
        return true;
    }

    public boolean allowEmpty() {
        return this.codec == IngredientCreatorAccess.chemical().codec();
    }

    public boolean isEmpty(ChemicalIngredient value) {
        return value.isEmpty();
    }

    public void buildUniqueId(UniqueIdBuilder builder, ChemicalIngredient value) {
        if (value instanceof CompoundChemicalIngredient) {
            CompoundChemicalIngredient c = (CompoundChemicalIngredient)value;
            boolean first = true;
            for (ChemicalIngredient in : c.children()) {
                if (first) {
                    first = false;
                } else {
                    builder.appendSeparator();
                }
                this.buildUniqueId(builder, in);
            }
        } else if (value instanceof TagChemicalIngredient) {
            TagChemicalIngredient tag = (TagChemicalIngredient)value;
            builder.append(tag.tag().location());
        } else {
            List list = value.getChemicalHolders();
            if (!list.isEmpty()) {
                builder.append(((Holder)list.getFirst()).getKey());
            }
        }
    }
}

