/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode.compiler;

import org.objectweb.asm.Type;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.javabytecode.JavaBytecodeContext;
import org.openzen.zenscript.javabytecode.compiler.JavaTypeExpressionVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaMethod;

public class ArrayHelperType {
    private final TypeID elementType;
    private final JavaBytecodeContext context;

    public ArrayHelperType(TypeID elementType, JavaBytecodeContext context) {
        this.elementType = elementType;
        this.context = context;
    }

    public ArrayHelperType getWithOneDimensionLess() {
        ArrayTypeID arrayTypeID = (ArrayTypeID)this.elementType;
        return new ArrayHelperType(arrayTypeID.removeOneDimension(), this.context);
    }

    public void newArray(JavaWriter javaWriter) {
        if (this.elementType instanceof GenericTypeID) {
            this.elementType.accept(javaWriter, new JavaTypeExpressionVisitor(this.context));
            javaWriter.swap();
            JavaClass arrayClass = JavaClass.fromInternalName("java/lang/reflect/Array", JavaClass.Kind.CLASS);
            javaWriter.invokeStatic(JavaMethod.getStatic(arrayClass, "newInstance", "(Ljava/lang/Class;I)Ljava/lang/Object;", 0));
            javaWriter.checkCast("[Ljava/lang/Object;");
        } else {
            javaWriter.newArray(this.context.getType(this.elementType));
        }
    }

    public Type getASMElementType() {
        return this.context.getType(this.elementType);
    }
}

