/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.item;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.item.ActionSetItemProperty;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.blamejared.crafttweaker_annotations.annotations.TaggableElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DebugStickState;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/item/ItemDefinition")
@NativeTypeRegistration(value=Item.class, zenCodeName="crafttweaker.api.item.ItemDefinition")
@TaggableElement(value="minecraft:item")
public class ExpandItem {
    @ZenCodeType.StaticExpansionMethod
    public static DataComponentMap commonItemComponents() {
        return DataComponents.COMMON_ITEM_COMPONENTS;
    }

    public static <T> void setComponent(Item internal, DataComponentType<T> type, T value) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<T>(internal, type, value));
    }

    @ZenCodeType.Method
    public static <T> void setComponent(Item internal, Class<T> clazz, DataComponentType<T> type, T value) {
        ExpandItem.setComponent(internal, type, value);
    }

    @ZenCodeType.Method
    public static void setJsonComponent(Item internal, DataComponentType type, @ZenCodeType.Nullable IData value) {
        if (value == null) {
            ExpandItem.remove(internal, type);
        } else {
            Codec codec = type.codecOrThrow();
            DataResult decode = codec.decode(IDataOps.INSTANCE.withTagAddingRegistryAccess(), (Object)value);
            ExpandItem.setComponent(internal, type, ((Pair)decode.getOrThrow()).getFirst());
        }
    }

    @ZenCodeType.Method
    public static void remove(Item internal, DataComponentType type) {
        ExpandItem.setComponent(internal, type, null);
    }

    @ZenCodeType.Setter(value="customData")
    public static void setCustomData(Item internal, CustomData customData) {
        ExpandItem.setComponent(internal, DataComponents.CUSTOM_DATA, customData);
    }

    @ZenCodeType.Setter(value="maxStackSize")
    public static void setMaxStackSize(Item internal, int maxStackSize) {
        ExpandItem.setComponent(internal, DataComponents.MAX_STACK_SIZE, maxStackSize);
    }

    @ZenCodeType.Setter(value="maxDamage")
    public static void setMaxDamage(Item internal, int maxDamage) {
        ExpandItem.setComponent(internal, DataComponents.MAX_DAMAGE, maxDamage);
    }

    @ZenCodeType.Setter(value="unbreakable")
    public static void setUnbreakable(Item internal, Unbreakable unbreakable) {
        ExpandItem.setComponent(internal, DataComponents.UNBREAKABLE, unbreakable);
    }

    @ZenCodeType.Setter(value="customName")
    public static void setCustomName(Item internal, Component component) {
        ExpandItem.setComponent(internal, DataComponents.CUSTOM_NAME, component);
    }

    @ZenCodeType.Setter(value="itemName")
    public static void setItemName(Item internal, Component component) {
        ExpandItem.setComponent(internal, DataComponents.ITEM_NAME, component);
    }

    @ZenCodeType.Setter(value="lore")
    public static void setLore(Item internal, ItemLore lore) {
        ExpandItem.setComponent(internal, DataComponents.LORE, lore);
    }

    @ZenCodeType.Setter(value="rarity")
    public static void setRarity(Item internal, Rarity rarity) {
        ExpandItem.setComponent(internal, DataComponents.RARITY, rarity);
    }

    @ZenCodeType.Setter(value="enchantments")
    public static void setEnchantments(Item internal, ItemEnchantments enchantments) {
        ExpandItem.setComponent(internal, DataComponents.ENCHANTMENTS, enchantments);
    }

    @ZenCodeType.Method
    public static void addEnchantment(Item internal, Enchantment enchantment, int level) {
        ItemEnchantments enchantments = (ItemEnchantments)internal.components().getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(enchantments);
        mutable.set(Services.REGISTRY.holderOrThrow(Registries.ENCHANTMENT, enchantment), level);
        ExpandItem.setComponent(internal, DataComponents.ENCHANTMENTS, mutable.toImmutable());
    }

    @ZenCodeType.Setter(value="canBreak")
    public static void setCanBreak(Item internal, AdventureModePredicate predicate) {
        ExpandItem.setComponent(internal, DataComponents.CAN_BREAK, predicate);
    }

    @ZenCodeType.Setter(value="canPlaceOn")
    public static void setCanPlaceOn(Item internal, AdventureModePredicate predicate) {
        ExpandItem.setComponent(internal, DataComponents.CAN_PLACE_ON, predicate);
    }

    @ZenCodeType.Setter(value="attributeModifiers")
    public static void setAttributeModifiers(Item internal, ItemAttributeModifiers modifiers) {
        ExpandItem.setComponent(internal, DataComponents.ATTRIBUTE_MODIFIERS, modifiers);
    }

    @ZenCodeType.Method
    public static void addAttributeModifier(Item internal, Attribute attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)internal.components().getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        if (modifiers.modifiers().isEmpty()) {
            modifiers = internal.getDefaultAttributeModifiers();
        }
        ExpandItem.setComponent(internal, DataComponents.ATTRIBUTE_MODIFIERS, modifiers.withModifierAdded(Services.REGISTRY.holderOrThrow(Registries.ATTRIBUTE, attribute), modifier, slot));
    }

    @ZenCodeType.Setter(value="customModelData")
    public static void setCustomModelData(Item internal, CustomModelData modelData) {
        ExpandItem.setComponent(internal, DataComponents.CUSTOM_MODEL_DATA, modelData);
    }

    @ZenCodeType.Setter(value="hideAdditionalTooltip")
    public static void setHideAdditionalTooltip(Item internal, boolean hideAdditionalTooltip) {
        if (hideAdditionalTooltip) {
            ExpandItem.setComponent(internal, DataComponents.HIDE_ADDITIONAL_TOOLTIP, Unit.INSTANCE);
        } else {
            ExpandItem.remove(internal, DataComponents.HIDE_ADDITIONAL_TOOLTIP);
        }
    }

    @ZenCodeType.Setter(value="hideTooltip")
    public static void setHideTooltip(Item internal, boolean hideTooltip) {
        if (hideTooltip) {
            ExpandItem.setComponent(internal, DataComponents.HIDE_TOOLTIP, Unit.INSTANCE);
        } else {
            ExpandItem.remove(internal, DataComponents.HIDE_TOOLTIP);
        }
    }

    @ZenCodeType.Setter(value="repairCost")
    public static void setRepairCost(Item internal, int cost) {
        ExpandItem.setComponent(internal, DataComponents.REPAIR_COST, cost);
    }

    @ZenCodeType.Setter(value="creativeSlotLock")
    public static void setCreativeSlotLock(Item internal, boolean creativeSlotLock) {
        if (creativeSlotLock) {
            ExpandItem.setComponent(internal, DataComponents.CREATIVE_SLOT_LOCK, Unit.INSTANCE);
        } else {
            ExpandItem.remove(internal, DataComponents.CREATIVE_SLOT_LOCK);
        }
    }

    @ZenCodeType.Setter(value="enchantmentGlintOverride")
    public static void setEnchantmentGlintOverride(Item internal, boolean value) {
        ExpandItem.setComponent(internal, DataComponents.ENCHANTMENT_GLINT_OVERRIDE, value);
    }

    @ZenCodeType.Setter(value="intangibleProjectile")
    public static void setIntangibleProjectile(Item internal, boolean intangibleProjectile) {
        if (intangibleProjectile) {
            ExpandItem.setComponent(internal, DataComponents.INTANGIBLE_PROJECTILE, Unit.INSTANCE);
        } else {
            ExpandItem.remove(internal, DataComponents.INTANGIBLE_PROJECTILE);
        }
    }

    @ZenCodeType.Setter(value="food")
    public static void setFood(Item internal, FoodProperties food) {
        ExpandItem.setComponent(internal, DataComponents.FOOD, food);
    }

    @ZenCodeType.Setter(value="fireResistant")
    public static void setFireResistant(Item internal, boolean intangibleProjectile) {
        if (intangibleProjectile) {
            ExpandItem.setComponent(internal, DataComponents.FIRE_RESISTANT, Unit.INSTANCE);
        } else {
            ExpandItem.remove(internal, DataComponents.FIRE_RESISTANT);
        }
    }

    @ZenCodeType.Setter(value="tool")
    public static void setTool(Item internal, Tool tool) {
        ExpandItem.setComponent(internal, DataComponents.TOOL, tool);
    }

    @ZenCodeType.Setter(value="storedEnchantments")
    public static void setStoredEnchantments(Item internal, ItemEnchantments storedEnchantments) {
        ExpandItem.setComponent(internal, DataComponents.STORED_ENCHANTMENTS, storedEnchantments);
    }

    @ZenCodeType.Setter(value="dyedColor")
    public static void setDyedColor(Item internal, DyedItemColor color) {
        ExpandItem.setComponent(internal, DataComponents.DYED_COLOR, color);
    }

    @ZenCodeType.Setter(value="mapColor")
    public static void setMapColor(Item internal, MapItemColor mapColor) {
        ExpandItem.setComponent(internal, DataComponents.MAP_COLOR, mapColor);
    }

    @ZenCodeType.Setter(value="mapId")
    public static void setMapId(Item internal, MapId id) {
        ExpandItem.setComponent(internal, DataComponents.MAP_ID, id);
    }

    @ZenCodeType.Setter(value="mapDecorations")
    public static void setMapDecorations(Item internal, MapDecorations mapDecorations) {
        ExpandItem.setComponent(internal, DataComponents.MAP_DECORATIONS, mapDecorations);
    }

    @ZenCodeType.Setter(value="mapPostProcessing")
    public static void setMapPostProcessing(Item internal, MapPostProcessing mapPostProcessing) {
        ExpandItem.setComponent(internal, DataComponents.MAP_POST_PROCESSING, mapPostProcessing);
    }

    @ZenCodeType.Setter(value="chargedProjectiles")
    public static void setChargedProjectiles(Item internal, ChargedProjectiles chargedProjectiles) {
        ExpandItem.setComponent(internal, DataComponents.CHARGED_PROJECTILES, chargedProjectiles);
    }

    @ZenCodeType.Setter(value="bundleContents")
    public static void setBundleContents(Item internal, BundleContents bundleContents) {
        ExpandItem.setComponent(internal, DataComponents.BUNDLE_CONTENTS, bundleContents);
    }

    @ZenCodeType.Setter(value="potionContents")
    public static void setPotionContents(Item internal, PotionContents potionContents) {
        ExpandItem.setComponent(internal, DataComponents.POTION_CONTENTS, potionContents);
    }

    @ZenCodeType.Setter(value="suspiciousStewEffects")
    public static void setSuspiciousStewEffects(Item internal, SuspiciousStewEffects suspiciousStewEffects) {
        ExpandItem.setComponent(internal, DataComponents.SUSPICIOUS_STEW_EFFECTS, suspiciousStewEffects);
    }

    @ZenCodeType.Setter(value="writableBookContent")
    public static void setWritableBookContent(Item internal, WritableBookContent writableBookContent) {
        ExpandItem.setComponent(internal, DataComponents.WRITABLE_BOOK_CONTENT, writableBookContent);
    }

    @ZenCodeType.Setter(value="writtenBookContent")
    public static void setWrittenBookContent(Item internal, WrittenBookContent writtenBookContent) {
        ExpandItem.setComponent(internal, DataComponents.WRITTEN_BOOK_CONTENT, writtenBookContent);
    }

    @ZenCodeType.Setter(value="trim")
    public static void setTrim(Item internal, ArmorTrim trim) {
        ExpandItem.setComponent(internal, DataComponents.TRIM, trim);
    }

    @ZenCodeType.Setter(value="debugStickState")
    public static void setDebugStickState(Item internal, DebugStickState debugStickState) {
        ExpandItem.setComponent(internal, DataComponents.DEBUG_STICK_STATE, debugStickState);
    }

    @ZenCodeType.Setter(value="entityData")
    public static void setEntityData(Item internal, CustomData data) {
        ExpandItem.setComponent(internal, DataComponents.ENTITY_DATA, data);
    }

    @ZenCodeType.Setter(value="bucketEntityData")
    public static void setBucketEntityData(Item internal, CustomData data) {
        ExpandItem.setComponent(internal, DataComponents.BUCKET_ENTITY_DATA, data);
    }

    @ZenCodeType.Setter(value="blockEntityData")
    public static void setBlockEntityData(Item internal, CustomData data) {
        ExpandItem.setComponent(internal, DataComponents.BLOCK_ENTITY_DATA, data);
    }

    @ZenCodeType.Setter(value="instrument")
    public static void setInstrument(Item internal, Instrument instrument) {
        ExpandItem.setComponent(internal, DataComponents.INSTRUMENT, Services.REGISTRY.holderOrThrow(Registries.INSTRUMENT, instrument));
    }

    @ZenCodeType.Setter(value="ominousBottleAmplifier")
    public static void setOminousBottleAmplifier(Item internal, int amplifier) {
        ExpandItem.setComponent(internal, DataComponents.OMINOUS_BOTTLE_AMPLIFIER, amplifier);
    }

    @ZenCodeType.Setter(value="recipes")
    public static void setRecipes(Item internal, List<ResourceLocation> recipes) {
        ExpandItem.setComponent(internal, DataComponents.RECIPES, recipes);
    }

    @ZenCodeType.Setter(value="lodestoneTracker")
    public static void setLodestoneTracker(Item internal, LodestoneTracker tracker) {
        ExpandItem.setComponent(internal, DataComponents.LODESTONE_TRACKER, tracker);
    }

    @ZenCodeType.Setter(value="fireworkExplosion")
    public static void setFireworkExplosion(Item internal, FireworkExplosion explosion) {
        ExpandItem.setComponent(internal, DataComponents.FIREWORK_EXPLOSION, explosion);
    }

    @ZenCodeType.Setter(value="fireworks")
    public static void setFireworks(Item internal, Fireworks fireworks) {
        ExpandItem.setComponent(internal, DataComponents.FIREWORKS, fireworks);
    }

    @ZenCodeType.Setter(value="profile")
    public static void setProfile(Item internal, ResolvableProfile profile) {
        ExpandItem.setComponent(internal, DataComponents.PROFILE, profile);
    }

    @ZenCodeType.Setter(value="noteBlockSound")
    public static void setNoteBlockSound(Item internal, ResourceLocation sound) {
        ExpandItem.setComponent(internal, DataComponents.NOTE_BLOCK_SOUND, sound);
    }

    @ZenCodeType.Setter(value="bannerPatterns")
    public static void setBannerPatterns(Item internal, BannerPatternLayers patterns) {
        ExpandItem.setComponent(internal, DataComponents.BANNER_PATTERNS, patterns);
    }

    @ZenCodeType.Setter(value="baseColor")
    public static void setBaseColor(Item internal, DyeColor baseColor) {
        ExpandItem.setComponent(internal, DataComponents.BASE_COLOR, baseColor);
    }

    @ZenCodeType.Setter(value="potDecorations")
    public static void setPotDecorations(Item internal, PotDecorations decorations) {
        ExpandItem.setComponent(internal, DataComponents.POT_DECORATIONS, decorations);
    }

    @ZenCodeType.Setter(value="container")
    public static void setContainer(Item internal, ItemContainerContents container) {
        ExpandItem.setComponent(internal, DataComponents.CONTAINER, container);
    }

    @ZenCodeType.Setter(value="blockState")
    public static void setBlockState(Item internal, BlockItemStateProperties blockState) {
        ExpandItem.setComponent(internal, DataComponents.BLOCK_STATE, blockState);
    }

    @ZenCodeType.Setter(value="bees")
    public static void setBees(Item internal, List<BeehiveBlockEntity.Occupant> occupants) {
        ExpandItem.setComponent(internal, DataComponents.BEES, occupants);
    }

    @ZenCodeType.Setter(value="lockCode")
    public static void setLockCode(Item internal, LockCode code) {
        ExpandItem.setComponent(internal, DataComponents.LOCK, code);
    }

    @ZenCodeType.Setter(value="containerLoot")
    public static void setContainerLoot(Item internal, SeededContainerLoot containerLoot) {
        ExpandItem.setComponent(internal, DataComponents.CONTAINER_LOOT, containerLoot);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="defaultInstance")
    @ZenCodeType.Caster(implicit=true)
    public static IItemStack getDefaultInstance(Item internal) {
        return IItemStack.of(internal.getDefaultInstance());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="registryName")
    public static ResourceLocation getRegistryName(Item internal) {
        return BuiltInRegistries.ITEM.getKey((Object)internal);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="commandString")
    public static String getCommandString(Item internal) {
        return "<item:" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)internal)) + ">.definition";
    }
}

