/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.component;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Optionull;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/component/DataComponentPatch")
@NativeTypeRegistration(value=DataComponentPatch.class, zenCodeName="crafttweaker.api.component.DataComponentPatch")
public class ExpandDataComponentPatch {
    @ZenCodeType.StaticExpansionMethod
    public static DataComponentPatch.Builder builder() {
        return DataComponentPatch.builder();
    }

    @ZenCodeType.Method
    public static <T> DataComponentPatch forget(DataComponentPatch internal, Class<T> tClass, DataComponentType<T> component) {
        return internal.forget(dataComponentType -> dataComponentType == component);
    }

    @ZenCodeType.Getter(value="isEmpty")
    public static boolean isEmpty(DataComponentPatch internal) {
        return internal.isEmpty();
    }

    @ZenCodeType.Getter(value="size")
    public static int size(DataComponentPatch internal) {
        return internal.size();
    }

    @ZenCodeType.Method
    public static <T> @ZenCodeType.Nullable T getComponent(DataComponentPatch internal, DataComponentType<T> type) {
        Optional component = internal.get(type);
        return (T)Optionull.map((Object)component, t -> t.orElse(null));
    }

    @ZenCodeType.Method
    public static DataComponentPatch.SplitResult split(DataComponentPatch internal) {
        return internal.split();
    }

    @ZenRegister
    @Document(value="vanilla/api/component/DataComponentPatchSplitResult")
    @NativeTypeRegistration(value=DataComponentPatch.SplitResult.class, zenCodeName="crafttweaker.api.component.DataComponentPatchSplitResult")
    public static class ExpandDataComponentPatchSplitResult {
        @ZenCodeType.Getter(value="added")
        public static DataComponentMap added(DataComponentPatch.SplitResult internal) {
            return internal.added();
        }

        @ZenCodeType.Getter(value="removed")
        public static Set<DataComponentType<?>> removed(DataComponentPatch.SplitResult internal) {
            return internal.removed();
        }
    }

    @ZenRegister
    @Document(value="vanilla/api/component/DataComponentPatchBuilder")
    @NativeTypeRegistration(value=DataComponentPatch.Builder.class, zenCodeName="crafttweaker.api.component.DataComponentPatchBuilder")
    public static class ExpandDataComponentPatchBuilder {
        @ZenCodeType.Method
        public static <T> DataComponentPatch.Builder setComponent(DataComponentPatch.Builder internal, Class<T> tClass, DataComponentType<T> type, T value) {
            return internal.set(type, value);
        }

        @ZenCodeType.Method
        public static <T> DataComponentPatch.Builder remove(DataComponentPatch.Builder internal, Class<T> tClass, DataComponentType<T> type) {
            return internal.remove(type);
        }

        @ZenCodeType.Method
        public static <T> DataComponentPatch.Builder setComponent(DataComponentPatch.Builder internal, Class<T> tClass, TypedDataComponent<T> type) {
            return internal.set(type);
        }

        @ZenCodeType.Method
        public static DataComponentPatch build(DataComponentPatch.Builder internal) {
            return internal.build();
        }
    }
}

