/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script;

import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class ScriptSerializer
implements RecipeSerializer<ScriptRecipe> {
    public static final ScriptSerializer INSTANCE = new ScriptSerializer();
    public static final MapCodec<ScriptRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("fileName").forGetter(ScriptRecipe::getFileName), (App)Codec.STRING.fieldOf("content").forGetter(ScriptRecipe::getContent)).apply((Applicative)instance, ScriptRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ScriptRecipe> STREAM_CODEC = StreamCodec.of(ScriptSerializer::toNetwork, ScriptSerializer::fromNetwork);

    public MapCodec<ScriptRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ScriptRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    private static ScriptRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        String fileName = buffer.readUtf();
        int parts = buffer.readVarInt();
        StringBuilder script = new StringBuilder();
        while (parts-- > 0) {
            script.append(buffer.readUtf());
        }
        return new ScriptRecipe(fileName, script.toString());
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, ScriptRecipe recipe) {
        String contents = recipe.getContent();
        LinkedList split = Lists.newLinkedList((Iterable)Splitter.fixedLength((int)4095).split((CharSequence)contents));
        buffer.writeUtf(recipe.getFileName());
        buffer.writeVarInt(split.size());
        split.forEach(arg_0 -> ((RegistryFriendlyByteBuf)buffer).writeUtf(arg_0));
    }
}

