/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.registry.zencode;

import com.blamejared.crafttweaker.api.zencode.IScriptLoader;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;

public final class EnumBracketRegistry {
    private final Map<IScriptLoader, EnumData> data = new HashMap<IScriptLoader, EnumData>();

    public <T extends Enum<T>> void register(IScriptLoader loader, ResourceLocation id, Class<T> clazz) {
        EnumData data = this.data.computeIfAbsent(loader, it -> {
            throw new IllegalStateException("No data for loader " + String.valueOf(loader) + ": this cannot happen");
        });
        Map<ResourceLocation, Class<Enum<?>>> enums = data.enums();
        Class<Enum<?>> old = enums.get(id);
        if (old != null) {
            throw new IllegalArgumentException("Attempted enum overriding on id " + String.valueOf(id) + ": old " + old.getName() + ", new " + clazz.getName());
        }
        enums.put(id, clazz);
    }

    public void fillLoaderData(Collection<IScriptLoader> loader) {
        loader.forEach(it -> this.data.put((IScriptLoader)it, new EnumData()));
    }

    public void applyInheritanceRules() {
        Map<IScriptLoader, EnumData> snapshot = this.createSnapshot();
        Map<IScriptLoader, EnumData> inherited = this.applyInheritanceRules(snapshot);
        this.data.clear();
        this.data.putAll(inherited);
    }

    public <T extends Enum<T>> Optional<Class<T>> getEnum(IScriptLoader loader, ResourceLocation type) {
        return Optional.ofNullable(this.data.get(loader)).flatMap(it -> Optional.ofNullable(it.enums().get(type))).map(it -> it);
    }

    public Map<ResourceLocation, Class<? extends Enum<?>>> getEnums(IScriptLoader loader) {
        return ImmutableMap.copyOf(this.data.getOrDefault(loader, new EnumData()).enums());
    }

    private Map<IScriptLoader, EnumData> createSnapshot() {
        return this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> new EnumData(new HashMap(((EnumData)it.getValue()).enums()))));
    }

    private Map<IScriptLoader, EnumData> applyInheritanceRules(Map<IScriptLoader, EnumData> snapshot) {
        return snapshot.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> this.applyInheritanceRules((IScriptLoader)it.getKey(), snapshot)));
    }

    private EnumData applyInheritanceRules(IScriptLoader loader, Map<IScriptLoader, EnumData> snapshot) {
        HashMap inheritedData = new HashMap();
        Collection<Map<ResourceLocation, Class<Enum<?>>>> inheritanceData = this.computeInheritanceData(loader, snapshot);
        inheritanceData.forEach(it -> {
            try {
                this.tryMerge(inheritedData, (Map<ResourceLocation, Class<? extends Enum<?>>>)it);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to apply inheritance rules for " + loader.name(), e);
            }
        });
        return new EnumData(inheritedData);
    }

    private Collection<Map<ResourceLocation, Class<? extends Enum<?>>>> computeInheritanceData(IScriptLoader loader, Map<IScriptLoader, EnumData> snapshot) {
        return Stream.concat(loader.allInheritedLoaders().stream(), Stream.of(loader)).map(snapshot::get).filter(Objects::nonNull).map(EnumData::enums).toList();
    }

    private void tryMerge(Map<ResourceLocation, Class<? extends Enum<?>>> loaderEnums, Map<ResourceLocation, Class<? extends Enum<?>>> inheritedEnums) {
        inheritedEnums.forEach((id, clazz) -> {
            if (loaderEnums.containsKey(id)) {
                throw new IllegalStateException(String.valueOf(id) + " is already assigned to an enum");
            }
            loaderEnums.put((ResourceLocation)id, (Class<? extends Enum<?>>)clazz);
        });
    }

    private record EnumData(Map<ResourceLocation, Class<? extends Enum<?>>> enums) {
        EnumData() {
            this(new HashMap());
        }
    }
}

