/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.logging;

import com.blamejared.crafttweaker.gametest.logging.appender.GameTestLoggerAppender;
import com.blamejared.crafttweaker.impl.logging.PlayerAppender;
import com.blamejared.crafttweaker.platform.Services;
import java.io.Serializable;
import java.util.Objects;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.LevelRangeFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public final class CraftTweakerLog4jEditor {
    private static final String CRT_LOG_NAME = "CRT_LOG";
    private static final String PLAYER_LOG_NAME = "CRT_PLAYER";
    private static final String GAME_TEST_LOG_NAME = "CRT_GAMETEST";
    private static CraftTweakerLog4jEditor instance;
    private final PlayerAppender playerAppender;
    private final GameTestLoggerAppender gameTestAppender;

    private CraftTweakerLog4jEditor(PlayerAppender playerAppender, GameTestLoggerAppender gameTestAppender) {
        this.playerAppender = playerAppender;
        this.gameTestAppender = gameTestAppender;
    }

    public static void edit() {
        LoggerContext context = CraftTweakerLog4jEditor.findContext();
        Configuration config = context.getConfiguration();
        PatternLayout logPattern = PatternLayout.newBuilder().withPattern(Services.PLATFORM.getLogFormat()).build();
        PatternLayout playerPattern = PatternLayout.newBuilder().withPattern("%msg%n%throwable{short.message}").build();
        PatternLayout gameTestPattern = PatternLayout.newBuilder().withPattern("%msg%n%throwable").build();
        FileAppender fileAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName("logs/crafttweaker.log").withAppend(false).setName(CRT_LOG_NAME)).withImmediateFlush(true)).setIgnoreExceptions(false)).setConfiguration(config)).setLayout((Layout)logPattern)).build();
        LevelRangeFilter playerFilter = LevelRangeFilter.createFilter((Level)Level.FATAL, (Level)Level.WARN, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY);
        PlayerAppender playerAppender = PlayerAppender.createAppender(PLAYER_LOG_NAME, (Filter)playerFilter, (Layout<? extends Serializable>)playerPattern);
        LevelRangeFilter gameTestFilter = LevelRangeFilter.createFilter((Level)Level.FATAL, (Level)Level.ALL, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY);
        GameTestLoggerAppender gameTestAppender = GameTestLoggerAppender.createAppender(GAME_TEST_LOG_NAME, (Filter)gameTestFilter, (Layout<? extends Serializable>)gameTestPattern);
        fileAppender.start();
        playerAppender.start();
        gameTestAppender.start();
        config.addAppender((Appender)fileAppender);
        config.addAppender((Appender)playerAppender);
        config.addAppender((Appender)gameTestAppender);
        AppenderRef[] refs = new AppenderRef[]{CraftTweakerLog4jEditor.ref(CRT_LOG_NAME), CraftTweakerLog4jEditor.ref(PLAYER_LOG_NAME)};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)(Services.PLATFORM.isDevelopmentEnvironment() ? Level.DEBUG : Level.INFO), (String)"CRT_LOG_FILE", (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)fileAppender, null, null);
        loggerConfig.addAppender((Appender)playerAppender, null, null);
        loggerConfig.addAppender((Appender)gameTestAppender, null, null);
        config.addLogger("CRT_LOG_FILE", loggerConfig);
        context.updateLoggers();
        instance = new CraftTweakerLog4jEditor(playerAppender, gameTestAppender);
    }

    private static LoggerContext findContext() {
        org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
        if (loggerContext instanceof LoggerContext) {
            LoggerContext context = (LoggerContext)loggerContext;
            return context;
        }
        throw new IllegalStateException("Invalid context");
    }

    private static AppenderRef ref(String name) {
        return AppenderRef.createAppenderRef((String)name, null, null);
    }

    public static void addPlayer(Player player) {
        Objects.requireNonNull(instance, "Unable to add player before log init");
        CraftTweakerLog4jEditor.instance.playerAppender.addPlayerLogger(player);
    }

    public static void removePlayer(Player player) {
        Objects.requireNonNull(instance, "Unable to remove player before log init");
        CraftTweakerLog4jEditor.instance.playerAppender.removePlayerLogger(player);
    }

    public static void clearPreviousMessages() {
        Objects.requireNonNull(instance, "Unable to clear previous messages before log init");
        CraftTweakerLog4jEditor.instance.playerAppender.clearPreviousMessages();
    }

    public static void claimGameTestLogger() {
        Objects.requireNonNull(instance, "Unable to query messages before log init");
        CraftTweakerLog4jEditor.instance.gameTestAppender.claim();
    }

    public static GameTestLoggerAppender.QueryableLog queryGameTestLogger() {
        Objects.requireNonNull(instance, "Unable to query messages before log init");
        return CraftTweakerLog4jEditor.instance.gameTestAppender.query();
    }
}

